/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects.configs;

import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.RackElementType;
import org.netxms.client.constants.RackOrientation;

public class PassiveRackElement {
    public long id;
    public String name;
    public RackElementType type;
    public int position;
    public RackOrientation orientation;
    public int portCount;

    public PassiveRackElement() {
        this.id = 0L;
        this.name = "";
        this.type = RackElementType.PATCH_PANEL;
        this.position = 0;
        this.orientation = RackOrientation.FILL;
        this.portCount = 0;
    }

    public PassiveRackElement(NXCPMessage msg, long base) {
        this.id = msg.getFieldAsInt32(base++);
        this.name = msg.getFieldAsString(base++);
        this.type = RackElementType.getByValue(msg.getFieldAsInt32(base++));
        this.position = msg.getFieldAsInt32(base++);
        this.orientation = RackOrientation.getByValue(msg.getFieldAsInt32(base++));
        this.portCount = msg.getFieldAsInt32(base++);
    }

    public PassiveRackElement(PassiveRackElement element) {
        this.id = element.id;
        this.name = element.name;
        this.type = element.type;
        this.position = element.position;
        this.orientation = element.orientation;
    }

    public void fillMessage(NXCPMessage msg, long base) {
        msg.setFieldInt32(base++, (int)this.id);
        msg.setField(base++, this.name);
        msg.setFieldInt32(base++, this.type.getValue());
        msg.setFieldInt32(base++, this.position);
        msg.setFieldInt32(base++, this.orientation.getValue());
    }

    public void setType(RackElementType type) {
        this.type = type;
    }

    public RackElementType getType() {
        return this.type;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setOrientation(RackOrientation orientation) {
        this.orientation = orientation;
    }

    public RackOrientation getOrientation() {
        return this.orientation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getPortCount() {
        return this.portCount;
    }

    public void setPortCount(int portCount) {
        this.portCount = portCount;
    }

    public String toString() {
        return this.orientation.toString() + " " + this.position + " (" + this.name + ")";
    }
}

