/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ServerVariableDataType {
    STRING(0),
    BOOLEAN(1),
    INTEGER(2),
    CHOICE(3),
    COLOR(4);

    private static Logger logger;
    private static Map<Integer, ServerVariableDataType> lookupTableValue;
    private static Map<Integer, ServerVariableDataType> lookupTableCode;
    private int value;

    private ServerVariableDataType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ServerVariableDataType getByValue(int value) {
        ServerVariableDataType element = lookupTableValue.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return STRING;
        }
        return element;
    }

    public static ServerVariableDataType getByCode(char code) {
        ServerVariableDataType element = lookupTableCode.get(code);
        if (element == null) {
            logger.warn("Unknown type code " + code);
            return STRING;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(ServerVariableDataType.class);
        lookupTableValue = new HashMap<Integer, ServerVariableDataType>();
        lookupTableCode = new HashMap<Integer, ServerVariableDataType>();
        for (ServerVariableDataType element : ServerVariableDataType.values()) {
            lookupTableValue.put(element.value, element);
        }
        lookupTableCode.put(83, STRING);
        lookupTableCode.put(73, INTEGER);
        lookupTableCode.put(66, BOOLEAN);
        lookupTableCode.put(67, CHOICE);
        lookupTableCode.put(72, COLOR);
    }
}

