/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NodePollType {
    UNKNOWN(0),
    STATUS(1),
    CONFIGURATION_FULL(2),
    INTERFACES(3),
    TOPOLOGY(4),
    CONFIGURATION_NORMAL(5),
    INSTANCE_DISCOVERY(6);

    private static Logger logger;
    private static Map<Integer, NodePollType> lookupTable;
    private int value;

    private NodePollType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static NodePollType getByValue(int value) {
        NodePollType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(NodePollType.class);
        lookupTable = new HashMap<Integer, NodePollType>();
        for (NodePollType element : NodePollType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

