/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MapObjectDisplayMode {
    ICON(0),
    SMALL_LABEL(1),
    LARGE_LABEL(2),
    STATUS(3),
    FLOOR_PLAN(4);

    private static Logger logger;
    private static Map<Integer, MapObjectDisplayMode> lookupTable;
    private int value;

    private MapObjectDisplayMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MapObjectDisplayMode getByValue(int value) {
        MapObjectDisplayMode element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return ICON;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(MapObjectDisplayMode.class);
        lookupTable = new HashMap<Integer, MapObjectDisplayMode>();
        for (MapObjectDisplayMode element : MapObjectDisplayMode.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

