/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import org.netxms.base.NXCPMessage;

public class PortStopEntry {
    public static final char PROTOCOL_TCP = 'T';
    public static final char PROTOCOL_UDP = 'U';
    public static final char PROTOCOL_BOTH = 'B';
    private int port;
    private char protocol;

    public PortStopEntry(int port, char protocol) {
        this.port = port;
        this.protocol = protocol;
    }

    public PortStopEntry(NXCPMessage msg, long baseId) {
        this.port = msg.getFieldAsInt32(baseId);
        this.protocol = (char)msg.getFieldAsInt16(baseId + 1L);
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setFieldInt32(baseId, this.port);
        msg.setFieldInt16(baseId + 1L, this.protocol);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public char getProtocol() {
        return this.protocol;
    }

    public void setProtocol(char protocol) {
        this.protocol = protocol;
    }

    public boolean isTcpBlocked() {
        return this.protocol == 'T' || this.protocol == 'B';
    }

    public boolean isUdpBlocked() {
        return this.protocol == 'U' || this.protocol == 'B';
    }

    public String getProtocolString() {
        switch (this.protocol) {
            case 'T': {
                return "TCP";
            }
            case 'U': {
                return "UDP";
            }
            case 'B': {
                return "TCP/UDP";
            }
        }
        return "Unknown";
    }

    public String toString() {
        return "PortStopEntry [port=" + this.port + ", protocol=" + this.getProtocolString() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.port;
        result2 = 31 * result2 + this.protocol;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortStopEntry other = (PortStopEntry)obj;
        if (this.port != other.port) {
            return false;
        }
        return this.protocol == other.protocol;
    }
}

