/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Locale;
import org.netxms.client.constants.RCC;

public class NXCException
extends Exception {
    private static final long serialVersionUID = 1453981595988661915L;
    protected int errorCode;
    protected String additionalInfo;
    protected long[] relatedObjects;

    public NXCException(int errorCode) {
        this(errorCode, null, null, null);
    }

    public NXCException(int errorCode, String additionalInfo) {
        this(errorCode, additionalInfo, null, null);
    }

    public NXCException(int errorCode, String additionalInfo, long[] relatedObjects) {
        this(errorCode, additionalInfo, relatedObjects, null);
    }

    public NXCException(int errorCode, Throwable cause) {
        this(errorCode, null, null, cause);
    }

    public NXCException(int errorCode, String additionalInfo, long[] relatedObjects, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
        this.additionalInfo = additionalInfo;
        this.relatedObjects = relatedObjects;
    }

    protected String getErrorMessage(int code2, String lang) {
        return RCC.getText(code2, lang, this.additionalInfo);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public long[] getRelatedObjects() {
        return this.relatedObjects;
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage(this.errorCode, "en");
    }

    @Override
    public String getLocalizedMessage() {
        Locale locale2 = Locale.getDefault();
        return this.getErrorMessage(this.errorCode, locale2.getLanguage());
    }
}

