/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import java.net.InetAddress;
import org.netxms.base.InetAddressEx;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.RoutingProtocol;

public class Route {
    private InetAddressEx destination;
    private InetAddress nextHop;
    private int ifIndex;
    private String ifName;
    private int type;
    private int metric;
    private RoutingProtocol protocol;

    public Route(NXCPMessage msg, long baseId) {
        this.destination = msg.getFieldAsInetAddressEx(baseId);
        this.nextHop = msg.getFieldAsInetAddress(baseId + 1L);
        this.ifIndex = msg.getFieldAsInt32(baseId + 2L);
        this.type = msg.getFieldAsInt32(baseId + 3L);
        this.metric = msg.getFieldAsInt32(baseId + 4L);
        this.protocol = RoutingProtocol.getByValue(msg.getFieldAsInt32(baseId + 5L));
        this.ifName = msg.getFieldAsString(baseId + 6L);
    }

    public InetAddressEx getDestination() {
        return this.destination;
    }

    public InetAddress getNextHop() {
        return this.nextHop;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public String getIfName() {
        return this.ifName;
    }

    public int getType() {
        return this.type;
    }

    public int getMetric() {
        return this.metric;
    }

    public RoutingProtocol getProtocol() {
        return this.protocol;
    }

    public String toString() {
        return "Route [" + this.destination.toString() + " gw=" + this.nextHop.getHostAddress() + " iface=" + this.ifIndex + " type=" + this.type + " metric=" + this.metric + " proto=" + String.valueOf((Object)this.protocol) + "]";
    }
}

