/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.HashSet;
import java.util.Set;
import org.netxms.base.InetAddressEx;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.PollState;
import org.netxms.client.constants.AccessPointState;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.constants.LinkLayerDiscoveryProtocol;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.interfaces.PollingTarget;
import org.netxms.client.topology.RadioInterface;

public class AccessPoint
extends DataCollectionTarget
implements PollingTarget {
    private long wirelessDomainId;
    private long controllerId;
    private int index;
    private MacAddress macAddress;
    private InetAddressEx ipAddress;
    private AccessPointState state;
    private String vendor;
    private String model;
    private String serialNumber;
    private RadioInterface[] radios;
    private long peerNodeId;
    private long peerInterfaceId;
    private LinkLayerDiscoveryProtocol peerDiscoveryProtocol;

    public AccessPoint(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.wirelessDomainId = msg.getFieldAsInt64(599L);
        this.controllerId = msg.getFieldAsInt64(543L);
        this.index = msg.getFieldAsInt32(495L);
        this.macAddress = new MacAddress(msg.getFieldAsBinary(113L));
        this.ipAddress = msg.getFieldAsInetAddressEx(8L);
        this.state = AccessPointState.getByValue(msg.getFieldAsInt32(243L));
        this.vendor = msg.getFieldAsString(428L);
        this.model = msg.getFieldAsString(429L);
        this.serialNumber = msg.getFieldAsString(432L);
        this.peerNodeId = msg.getFieldAsInt64(373L);
        this.peerInterfaceId = msg.getFieldAsInt64(374L);
        this.peerDiscoveryProtocol = LinkLayerDiscoveryProtocol.getByValue(msg.getFieldAsInt32(472L));
        int count2 = msg.getFieldAsInt32(442L);
        this.radios = new RadioInterface[count2];
        long fieldId = 0x34000000L;
        for (int i = 0; i < count2; ++i) {
            this.radios[i] = new RadioInterface(this, msg, fieldId);
            fieldId += 10L;
        }
    }

    @Override
    public String getObjectClassName() {
        return "AccessPoint";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    public long getWirelessDomainId() {
        return this.wirelessDomainId;
    }

    public long getControllerId() {
        return this.controllerId;
    }

    public int getIndex() {
        return this.index;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public InetAddressEx getIpAddress() {
        return this.ipAddress;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getModel() {
        return this.model;
    }

    public RadioInterface[] getRadios() {
        return this.radios;
    }

    public AccessPointState getState() {
        return this.state;
    }

    public long getPeerNodeId() {
        return this.peerNodeId;
    }

    public long getPeerInterfaceId() {
        return this.peerInterfaceId;
    }

    public LinkLayerDiscoveryProtocol getPeerDiscoveryProtocol() {
        return this.peerDiscoveryProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNode getParentNode() {
        AbstractNode node = null;
        HashSet hashSet = this.parents;
        synchronized (hashSet) {
            for (Long id : this.parents) {
                AbstractObject object = this.session.findObjectById(id);
                if (!(object instanceof AbstractNode)) continue;
                node = (AbstractNode)object;
                break;
            }
        }
        return node;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        AccessPoint.addString(strings, this.model);
        AccessPoint.addString(strings, this.serialNumber);
        AccessPoint.addString(strings, this.vendor);
        AccessPoint.addString(strings, this.macAddress.toString());
        return strings;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public int getIfXTablePolicy() {
        return 0;
    }

    @Override
    public AgentCacheMode getAgentCacheMode() {
        return null;
    }

    @Override
    public long getPollerNodeId() {
        return 0L;
    }

    @Override
    public boolean canHaveAgent() {
        return false;
    }

    @Override
    public boolean canHaveInterfaces() {
        return false;
    }

    @Override
    public boolean canHavePollerNode() {
        return false;
    }

    @Override
    public boolean canUseEtherNetIP() {
        return false;
    }

    @Override
    public boolean canUseModbus() {
        return false;
    }

    @Override
    public PollState[] getPollStates() {
        return this.pollStates;
    }
}

