/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.configs;

import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.interfaces.NodeItemPair;

public class MapDataSource
implements NodeItemPair {
    public static final int ITEM = 1;
    public static final int TABLE = 2;
    protected long nodeId;
    protected long dciId;
    protected int type;
    protected String instance;
    protected String column;
    protected String formatString;

    public MapDataSource() {
        this.nodeId = 0L;
        this.dciId = 0L;
        this.setType(1);
        this.setInstance("");
        this.setColumn("");
        this.setFormatString("");
    }

    public MapDataSource(MapDataSource src) {
        this.nodeId = src.nodeId;
        this.dciId = src.dciId;
        this.setType(src.getType());
        this.formatString = src.formatString;
        this.setInstance(src.getInstance());
        this.setColumn(src.getColumn());
    }

    public MapDataSource(DciValue dci) {
        this.nodeId = dci.getNodeId();
        this.dciId = dci.getId();
        this.setType(dci.getDcObjectType());
        this.formatString = "";
        this.setInstance("");
        this.setColumn("");
    }

    public MapDataSource(long nodeId, long dciId) {
        this.nodeId = nodeId;
        this.dciId = dciId;
        this.setType(1);
        this.setInstance("");
        this.setColumn("");
        this.setFormatString("");
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        if (this.type == 2 && (this.column.isEmpty() || this.instance.isEmpty())) {
            return;
        }
        msg.setFieldInt32(baseId++, (int)this.nodeId);
        msg.setFieldInt32(baseId++, (int)this.dciId);
        if (this.type == 2) {
            msg.setField(baseId++, this.column);
            msg.setField(baseId++, this.instance);
        }
    }

    public String getFormatString() {
        return this.formatString == null ? "" : this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    @Override
    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public long getDciId() {
        return this.dciId;
    }

    public void setDciId(long dciId) {
        this.dciId = dciId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

