/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.IncidentState;
import org.netxms.client.events.IncidentComment;

public class Incident {
    private long id;
    private Date creationTime;
    private Date lastChangeTime;
    private IncidentState state;
    private int assignedUserId;
    private String title;
    private long sourceAlarmId;
    private long sourceObjectId;
    private int createdByUser;
    private int resolvedByUser;
    private int closedByUser;
    private Date resolveTime;
    private Date closeTime;
    private long[] linkedAlarmIds;
    private int commentsCount;
    private List<IncidentComment> comments;

    public Incident(NXCPMessage msg) {
        this.id = msg.getFieldAsInt64(880L);
        this.creationTime = msg.getFieldAsDate(240L);
        this.lastChangeTime = msg.getFieldAsDate(241L);
        this.state = IncidentState.getByValue(msg.getFieldAsInt32(881L));
        this.assignedUserId = msg.getFieldAsInt32(884L);
        this.title = msg.getFieldAsString(882L);
        this.sourceAlarmId = msg.getFieldAsInt64(885L);
        this.sourceObjectId = msg.getFieldAsInt64(3L);
        this.createdByUser = msg.getFieldAsInt32(35L);
        this.resolvedByUser = msg.getFieldAsInt32(419L);
        this.closedByUser = msg.getFieldAsInt32(886L);
        long rt = msg.getFieldAsInt64(888L);
        this.resolveTime = rt > 0L ? new Date(rt * 1000L) : null;
        long ct = msg.getFieldAsInt64(887L);
        this.closeTime = ct > 0L ? new Date(ct * 1000L) : null;
        this.commentsCount = msg.getFieldAsInt32(409L);
        this.linkedAlarmIds = msg.getFieldAsUInt32Array(559L);
        if (this.linkedAlarmIds == null) {
            this.linkedAlarmIds = new long[0];
        }
        this.comments = new ArrayList<IncidentComment>(this.commentsCount);
        long fieldId = 0x62000000L;
        for (int i = 0; i < this.commentsCount; ++i) {
            this.comments.add(new IncidentComment(msg, fieldId));
            fieldId += 10L;
        }
    }

    public long getId() {
        return this.id;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getLastChangeTime() {
        return this.lastChangeTime;
    }

    public IncidentState getState() {
        return this.state;
    }

    public int getAssignedUserId() {
        return this.assignedUserId;
    }

    public String getTitle() {
        return this.title;
    }

    public long getSourceAlarmId() {
        return this.sourceAlarmId;
    }

    public long getSourceObjectId() {
        return this.sourceObjectId;
    }

    public int getCreatedByUser() {
        return this.createdByUser;
    }

    public int getResolvedByUser() {
        return this.resolvedByUser;
    }

    public int getClosedByUser() {
        return this.closedByUser;
    }

    public Date getResolveTime() {
        return this.resolveTime;
    }

    public Date getCloseTime() {
        return this.closeTime;
    }

    public long[] getLinkedAlarmIds() {
        return this.linkedAlarmIds != null ? this.linkedAlarmIds : new long[]{};
    }

    public boolean hasLinkedAlarms() {
        return this.linkedAlarmIds != null && this.linkedAlarmIds.length > 0;
    }

    public int getCommentsCount() {
        return this.commentsCount;
    }

    public List<IncidentComment> getComments() {
        return Collections.unmodifiableList(this.comments);
    }

    public boolean isClosed() {
        return this.state == IncidentState.CLOSED;
    }

    public boolean isResolved() {
        return this.state == IncidentState.RESOLVED || this.state == IncidentState.CLOSED;
    }

    public String toString() {
        return "Incident [id=" + this.id + ", creationTime=" + String.valueOf(this.creationTime) + ", lastChangeTime=" + String.valueOf(this.lastChangeTime) + ", state=" + this.state.name() + ", assignedUserId=" + this.assignedUserId + ", title=" + this.title + ", sourceAlarmId=" + this.sourceAlarmId + ", sourceObjectId=" + this.sourceObjectId + ", createdByUser=" + this.createdByUser + ", resolvedByUser=" + this.resolvedByUser + ", closedByUser=" + this.closedByUser + ", resolveTime=" + String.valueOf(this.resolveTime) + ", closeTime=" + String.valueOf(this.closeTime) + ", linkedAlarmIds=" + Arrays.toString(this.linkedAlarmIds) + ", commentsCount=" + this.commentsCount + "]";
    }
}

