/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.UUID;
import org.netxms.base.NXCPMessage;

public class AgentPolicy {
    public static final String AGENT_CONFIG = "AgentConfig";
    public static final String FILE_DELIVERY = "FileDelivery";
    public static final String LOG_PARSER = "LogParserConfig";
    public static final String SUPPORT_APPLICATION = "SupportApplicationConfig";
    public static final long EXPAND_MACRO = 1L;
    private UUID guid;
    private String name;
    private String policyType;
    private String content;
    private int flags;

    public AgentPolicy(NXCPMessage msg) {
        this.guid = msg.getFieldAsUUID(222L);
        this.name = msg.getFieldAsString(20L);
        this.policyType = msg.getFieldAsString(336L);
        this.content = msg.getFieldAsString(81L);
        this.flags = msg.getFieldAsInt32(13L);
    }

    public AgentPolicy(String name, String type) {
        this.guid = null;
        this.name = name;
        this.policyType = type;
        this.content = "";
    }

    public AgentPolicy(NXCPMessage msg, long baseId) {
        this.guid = msg.getFieldAsUUID(baseId);
        this.policyType = msg.getFieldAsString(baseId + 1L);
        this.name = msg.getFieldAsString(baseId + 2L);
        this.content = msg.getFieldAsString(baseId + 3L);
        this.flags = msg.getFieldAsInt32(baseId + 4L);
    }

    public AgentPolicy(AgentPolicy src) {
        this.guid = null;
        this.name = src.name;
        this.policyType = src.policyType;
        this.content = src.content;
        this.flags = src.flags;
    }

    public void update(AgentPolicy src) {
        this.guid = src.guid;
        this.name = src.name;
        this.policyType = src.policyType;
        this.content = src.content;
        this.flags = src.flags;
    }

    public void fillMessage(NXCPMessage msg) {
        if (this.guid != null) {
            msg.setField(222L, this.guid);
        }
        msg.setField(20L, this.name);
        msg.setField(336L, this.policyType);
        msg.setField(81L, this.content);
        msg.setFieldInt32(13L, this.flags);
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setGuid(UUID newObjectGuid) {
        this.guid = newObjectGuid;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String toString() {
        return this.name;
    }
}

