/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import java.net.InetAddress;
import java.util.Date;
import org.netxms.base.NXCPMessage;

public class SnmpTrapLogRecord {
    private long id;
    private Date timestamp;
    private InetAddress sourceAddress;
    private long sourceNode;
    private String trapObjectId;
    private String varbinds;

    public SnmpTrapLogRecord(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt64(baseId);
        this.timestamp = msg.getFieldAsDate(baseId + 1L);
        this.sourceAddress = msg.getFieldAsInetAddress(baseId + 2L);
        this.sourceNode = msg.getFieldAsInt64(baseId + 3L);
        this.trapObjectId = msg.getFieldAsString(baseId + 4L);
        this.varbinds = msg.getFieldAsString(baseId + 5L);
    }

    public long getId() {
        return this.id;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public long getSourceNode() {
        return this.sourceNode;
    }

    public String getTrapObjectId() {
        return this.trapObjectId;
    }

    public String getVarbinds() {
        return this.varbinds;
    }
}

