/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.Set;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.PollState;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.constants.SensorDeviceClass;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.interfaces.PollingTarget;

public class Sensor
extends DataCollectionTarget
implements PollingTarget {
    private SensorDeviceClass deviceClass;
    private long gatewayId;
    private short modbusUnitId;
    private MacAddress macAddress;
    private String deviceAddress;
    private String vendor;
    private String model;
    private String serialNumber;

    public Sensor(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.gatewayId = msg.getFieldAsInt32(592L);
        this.modbusUnitId = msg.getFieldAsInt16(837L);
        this.macAddress = new MacAddress(msg.getFieldAsBinary(113L));
        this.deviceAddress = msg.getFieldAsString(585L);
        this.deviceClass = SensorDeviceClass.getByValue(msg.getFieldAsInt16(582L));
        this.vendor = msg.getFieldAsString(428L);
        this.model = msg.getFieldAsString(429L);
        this.serialNumber = msg.getFieldAsString(432L);
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    @Override
    public String getObjectClassName() {
        return "Sensor";
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        Sensor.addString(strings, this.macAddress.toString());
        Sensor.addString(strings, this.vendor);
        Sensor.addString(strings, this.model);
        Sensor.addString(strings, this.serialNumber);
        Sensor.addString(strings, this.deviceAddress);
        return strings;
    }

    public final String getVendor() {
        return this.vendor;
    }

    public String getModel() {
        return this.model;
    }

    public final String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public SensorDeviceClass getDeviceClass() {
        return this.deviceClass;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public long getGatewayId() {
        return this.gatewayId;
    }

    public short getModbusUnitId() {
        return this.modbusUnitId;
    }

    @Override
    public int getIfXTablePolicy() {
        return 0;
    }

    @Override
    public AgentCacheMode getAgentCacheMode() {
        return null;
    }

    @Override
    public long getPollerNodeId() {
        return 0L;
    }

    @Override
    public boolean canHaveAgent() {
        return false;
    }

    @Override
    public boolean canHaveInterfaces() {
        return false;
    }

    @Override
    public boolean canHavePollerNode() {
        return false;
    }

    @Override
    public boolean canUseEtherNetIP() {
        return false;
    }

    @Override
    public boolean canUseModbus() {
        return true;
    }

    @Override
    public PollState[] getPollStates() {
        return this.pollStates;
    }
}

