/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.DciContainerConfiguration;
import org.netxms.client.maps.configs.MapDataSource;
import org.netxms.client.maps.elements.NetworkMapElement;

public class NetworkMapDCIContainer
extends NetworkMapElement {
    private int backgroundColor;
    private int textColor;
    private int borderColor;
    private boolean borderRequired;
    private MapDataSource[] dciArray;

    protected NetworkMapDCIContainer(NXCPMessage msg, long baseId) {
        super(msg, baseId);
        String json2 = msg.getFieldAsString(baseId + 10L);
        try {
            DciContainerConfiguration config2 = new Gson().fromJson(json2, DciContainerConfiguration.class);
            this.backgroundColor = config2.getBackgroundColor();
            this.textColor = config2.getTextColor();
            this.borderColor = config2.getBorderColor();
            this.borderRequired = config2.isBorderRequired();
            this.dciArray = config2.getDciList();
        }
        catch (Exception e) {
            this.backgroundColor = 0xFFFFFF;
            this.textColor = 0x202020;
            this.borderColor = 0x202020;
            this.borderRequired = false;
            this.dciArray = null;
        }
    }

    public NetworkMapDCIContainer(long id) {
        super(id);
        this.type = 3;
        this.dciArray = null;
        this.backgroundColor = 0xFFFFFF;
        this.textColor = 0x202020;
        this.borderColor = 0x202020;
    }

    @Override
    public void fillMessage(NXCPMessage msg, long baseId) {
        super.fillMessage(msg, baseId);
        DciContainerConfiguration config2 = new DciContainerConfiguration();
        config2.setDciList(this.dciArray);
        config2.setBackgroundColor(this.backgroundColor);
        config2.setTextColor(this.textColor);
        config2.setBorderColor(this.borderColor);
        config2.setBorderRequired(this.borderRequired);
        msg.setFieldJson(baseId + 10L, config2);
    }

    public boolean hasDciData() {
        return this.dciArray != null && this.dciArray.length > 0;
    }

    public MapDataSource[] getObjectDCIArray() {
        return this.dciArray;
    }

    public void setObjectDCIArray(MapDataSource[] dciArray) {
        this.dciArray = dciArray;
    }

    public List<MapDataSource> getDciAsList() {
        ArrayList<MapDataSource> dciList = new ArrayList<MapDataSource>();
        if (this.hasDciData()) {
            for (MapDataSource dci : this.dciArray) {
                dciList.add(dci);
            }
        }
        return dciList;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public boolean isBorderRequired() {
        return this.borderRequired;
    }

    public void setBorderRequired(boolean borderRequired) {
        this.borderRequired = borderRequired;
    }
}

