/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.TableThreshold;

public class DataCollectionTable
extends DataCollectionObject {
    public static final int IDM_NONE = 0;
    public static final int IDM_AGENT_LIST = 1;
    public static final int IDM_AGENT_TABLE = 2;
    public static final int IDM_SNMP_WALK_VALUES = 3;
    public static final int IDM_SNMP_WALK_OIDS = 4;
    public static final int IDM_SCRIPT = 5;
    private String instanceColumn;
    private List<ColumnDefinition> columns;
    private List<TableThreshold> thresholds;

    public DataCollectionTable(DataCollectionConfiguration owner, NXCPMessage msg) {
        super(owner, msg);
        int i;
        this.instanceColumn = msg.getFieldAsString(412L);
        int count2 = msg.getFieldAsInt32(166L);
        this.columns = new ArrayList<ColumnDefinition>(count2);
        long fieldId = 0x30000000L;
        for (i = 0; i < count2; ++i) {
            this.columns.add(new ColumnDefinition(msg, fieldId));
            fieldId += 10L;
        }
        count2 = msg.getFieldAsInt32(54L);
        this.thresholds = new ArrayList<TableThreshold>(count2);
        fieldId = 0x20000000L;
        for (i = 0; i < count2; ++i) {
            TableThreshold t = new TableThreshold(msg, fieldId);
            this.thresholds.add(t);
            fieldId = t.getNextFieldId();
        }
    }

    public DataCollectionTable(DataCollectionConfiguration owner, long nodeId, long id) {
        super(owner, nodeId, id);
        this.instanceColumn = null;
        this.columns = new ArrayList<ColumnDefinition>(0);
        this.thresholds = new ArrayList<TableThreshold>(0);
    }

    public DataCollectionTable(DataCollectionConfiguration owner, long id) {
        this(owner, owner.getOwnerId(), id);
    }

    public DataCollectionTable(long nodeId, long id) {
        this(null, nodeId, id);
    }

    protected DataCollectionTable() {
        this(null, 0L, 0L);
    }

    protected DataCollectionTable(DataCollectionConfiguration owner, DataCollectionTable src) {
        super(owner, src);
        this.instanceColumn = src.instanceColumn;
        this.columns = new ArrayList<ColumnDefinition>(src.columns);
        this.thresholds = new ArrayList<TableThreshold>(src.thresholds);
    }

    @Override
    public void fillMessage(NXCPMessage msg) {
        int i;
        super.fillMessage(msg);
        msg.setFieldInt16(411L, 2);
        msg.setField(412L, this.instanceColumn);
        msg.setFieldInt32(166L, this.columns.size());
        long varId = 0x30000000L;
        for (i = 0; i < this.columns.size(); ++i) {
            this.columns.get(i).fillMessage(msg, varId);
            varId += 10L;
        }
        msg.setFieldInt32(54L, this.thresholds.size());
        varId = 0x20000000L;
        for (i = 0; i < this.thresholds.size(); ++i) {
            varId = this.thresholds.get(i).fillMessage(msg, varId);
        }
    }

    public String getInstanceColumn() {
        return this.instanceColumn;
    }

    public void setInstanceColumn(String instanceColumn) {
        this.instanceColumn = instanceColumn;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnDefinition> columns) {
        this.columns = columns;
    }

    public List<TableThreshold> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(List<TableThreshold> thresholds) {
        this.thresholds = thresholds;
    }
}

