/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataType {
    INT32(0),
    UINT32(1),
    INT64(2),
    UINT64(3),
    STRING(4),
    FLOAT(5),
    NULL(6),
    COUNTER32(7),
    COUNTER64(8);

    private static Logger logger;
    private static Map<Integer, DataType> lookupTable;
    private int value;

    private DataType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSigned() {
        return this == INT32 || this == INT64 || this == FLOAT;
    }

    public boolean is64bit() {
        return this == INT64 || this == UINT64 || this == COUNTER64;
    }

    public static DataType getByValue(int value) {
        DataType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return INT32;
        }
        return element;
    }

    public static DataType getTypeForCompare(DataType t1, DataType t2) {
        if (t1 == t2) {
            return t1;
        }
        if (t1 == STRING || t2 == STRING) {
            return STRING;
        }
        if (t1 == FLOAT || t2 == FLOAT) {
            return FLOAT;
        }
        if (t1.is64bit() || t2.is64bit()) {
            return t1.isSigned() && t2.isSigned() ? INT64 : UINT64;
        }
        return t1.isSigned() && t2.isSigned() ? INT32 : UINT32;
    }

    static {
        logger = LoggerFactory.getLogger(DataType.class);
        lookupTable = new HashMap<Integer, DataType>();
        for (DataType element : DataType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

