/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BusinessServiceCheckType {
    NONE(0),
    SCRIPT(1),
    DCI(2),
    OBJECT(3);

    private static Logger logger;
    private static Map<Integer, BusinessServiceCheckType> lookupTable;
    private int value;

    private BusinessServiceCheckType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BusinessServiceCheckType getByValue(int value) {
        BusinessServiceCheckType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return NONE;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(BusinessServiceCheckType.class);
        lookupTable = new HashMap<Integer, BusinessServiceCheckType>();
        for (BusinessServiceCheckType element : BusinessServiceCheckType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

