/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.ai;

import org.netxms.base.NXCPMessage;

public class AiFunctionCall {
    private long chatId;
    private String functionName;

    public AiFunctionCall(NXCPMessage msg) {
        this.chatId = msg.getFieldAsInt64(875L);
        this.functionName = msg.getFieldAsString(916L);
    }

    public long getChatId() {
        return this.chatId;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getDisplayName() {
        if (this.functionName == null || this.functionName.isEmpty()) {
            return "Processing";
        }
        String readable = this.functionName.replace('-', ' ').replace('_', ' ');
        String lower = readable.toLowerCase();
        if (lower.startsWith("get ")) {
            return "Getting" + readable.substring(3);
        }
        if (lower.startsWith("read ")) {
            return "Reading" + readable.substring(4);
        }
        if (lower.startsWith("find ")) {
            return "Finding" + readable.substring(4);
        }
        if (lower.startsWith("list ")) {
            return "Listing" + readable.substring(4);
        }
        if (lower.startsWith("search ")) {
            return "Searching" + readable.substring(6);
        }
        if (lower.startsWith("analyze ")) {
            return "Analyzing" + readable.substring(7);
        }
        if (lower.startsWith("query ")) {
            return "Querying" + readable.substring(5);
        }
        if (lower.startsWith("check ")) {
            return "Checking" + readable.substring(5);
        }
        if (lower.startsWith("create ")) {
            return "Creating" + readable.substring(6);
        }
        if (lower.startsWith("update ")) {
            return "Updating" + readable.substring(6);
        }
        if (lower.startsWith("delete ")) {
            return "Deleting" + readable.substring(6);
        }
        if (lower.startsWith("send ")) {
            return "Sending" + readable.substring(4);
        }
        if (lower.startsWith("load ")) {
            return "Loading" + readable.substring(4);
        }
        return Character.toUpperCase(readable.charAt(0)) + readable.substring(1);
    }
}

