/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.ai;

import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.AiTaskState;

public class AiAgentTask {
    private long id;
    private int userId;
    private String description;
    private String prompt;
    private AiTaskState state;
    private Date lastExecutionTime;
    private Date nextExecutionTime;
    private int iteration;
    private String explanation;

    public AiAgentTask(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt64(baseId);
        this.userId = msg.getFieldAsInt32(baseId + 1L);
        this.description = msg.getFieldAsString(baseId + 2L);
        this.prompt = msg.getFieldAsString(baseId + 3L);
        this.state = AiTaskState.getByValue(msg.getFieldAsInt32(baseId + 4L));
        this.lastExecutionTime = msg.getFieldAsDate(baseId + 5L);
        this.nextExecutionTime = msg.getFieldAsDate(baseId + 6L);
        this.iteration = msg.getFieldAsInt32(baseId + 7L);
        this.explanation = msg.getFieldAsString(baseId + 8L);
    }

    public long getId() {
        return this.id;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public AiTaskState getState() {
        return this.state;
    }

    public Date getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    public Date getNextExecutionTime() {
        return this.nextExecutionTime;
    }

    public int getIteration() {
        return this.iteration;
    }

    public String getExplanation() {
        return this.explanation;
    }
}

