/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.UserSession;
import org.netxms.nxmc.localization.DateFormatFactory;

public class UserSessionLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        UserSession s = (UserSession)element;
        switch (columnIndex) {
            case 10: {
                return s.getAgentPID() != 0L ? Long.toString(s.getAgentPID()) : "";
            }
            case 9: {
                switch (s.getAgentType()) {
                    case 0: {
                        return "session";
                    }
                    case 1: {
                        return "user";
                    }
                }
                return "none";
            }
            case 5: {
                return s.getClientAddress() != null && !s.getClientAddress().isAnyLocalAddress() ? s.getClientAddress().getHostAddress() : "";
            }
            case 4: {
                return s.getClientName();
            }
            case 6: {
                return s.getDisplayDescription();
            }
            case 0: {
                return Integer.toString(s.getId());
            }
            case 8: {
                return Integer.toString(s.getIdleTime());
            }
            case 7: {
                return s.getLoginTime() != null && s.getLoginTime().getTime() != 0L ? DateFormatFactory.getDateTimeFormat().format(s.getLoginTime()) : "";
            }
            case 3: {
                return s.isConnected() ? "Active" : "Disconnected";
            }
            case 2: {
                return s.getTerminal();
            }
            case 1: {
                return s.getLoginName();
            }
        }
        return null;
    }
}

