/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.netxms.base.MacAddress;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Circuit;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectTableView;
import org.netxms.nxmc.modules.objects.views.helpers.InterfaceListComparator;
import org.netxms.nxmc.modules.objects.views.helpers.InterfaceListFilter;
import org.netxms.nxmc.modules.objects.views.helpers.InterfaceListLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class InterfacesView
extends NodeSubObjectTableView {
    private final I18n i18n = LocalizationHelper.getI18n(InterfacesView.class);
    public static final int COLUMN_NODE = 0;
    public static final int COLUMN_ID = 1;
    public static final int COLUMN_NAME = 2;
    public static final int COLUMN_ALIAS = 3;
    public static final int COLUMN_INDEX = 4;
    public static final int COLUMN_DESCRIPTION = 5;
    public static final int COLUMN_IP_ADDRESS = 6;
    public static final int COLUMN_MAC_ADDRESS = 7;
    public static final int COLUMN_NIC_VENDOR = 8;
    public static final int COLUMN_VLAN = 9;
    public static final int COLUMN_MTU = 10;
    public static final int COLUMN_SPEED = 11;
    public static final int COLUMN_MAX_SPEED = 12;
    public static final int COLUMN_UTILIZATION = 13;
    public static final int COLUMN_TYPE = 14;
    public static final int COLUMN_PHYSICAL_LOCATION = 15;
    public static final int COLUMN_ADMIN_STATE = 16;
    public static final int COLUMN_OPER_STATE = 17;
    public static final int COLUMN_EXPECTED_STATE = 18;
    public static final int COLUMN_STP_STATE = 19;
    public static final int COLUMN_STATUS = 20;
    public static final int COLUMN_OSPF_AREA = 21;
    public static final int COLUMN_OSPF_TYPE = 22;
    public static final int COLUMN_OSPF_STATE = 23;
    public static final int COLUMN_8021X_PAE_STATE = 24;
    public static final int COLUMN_8021X_BACKEND_STATE = 25;
    public static final int COLUMN_PEER_NODE = 26;
    public static final int COLUMN_PEER_INTERFACE = 27;
    public static final int COLUMN_PEER_MAC_ADDRESS = 28;
    public static final int COLUMN_PEER_NIC_VENDOR = 29;
    public static final int COLUMN_PEER_IP_ADDRESS = 30;
    public static final int COLUMN_PEER_PROTOCOL = 31;
    public static final int COLUMN_PEER_LAST_UPDATED = 32;
    private InterfaceListLabelProvider labelProvider;
    private Action actionCopyMacAddressToClipboard;
    private Action actionCopyIpAddressToClipboard;
    private Action actionCopyPeerNameToClipboard;
    private Action actionCopyPeerMacToClipboard;
    private Action actionCopyPeerIpToClipboard;
    private boolean hideSubInterfaces = false;

    public InterfacesView() {
        super(LocalizationHelper.getI18n(InterfacesView.class).tr("Interfaces"), ResourceManager.getImageDescriptor((String)"icons/object-views/interfaces.png"), "objects.interfaces", true);
    }

    public int getPriority() {
        return 50;
    }

    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.hideSubInterfaces = PreferenceStore.getInstance().getAsBoolean("InterfacesView.HideSubInterfaces", this.hideSubInterfaces);
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.labelProvider.setNode(this.getObject());
        this.updateColumns();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.labelProvider.setNode(this.getObject());
        this.updateColumns();
    }

    protected void createViewer() {
        String[] names = new String[]{this.i18n.tr("Node"), this.i18n.tr("ID"), this.i18n.tr("Name"), this.i18n.tr("Alias"), this.i18n.tr("Index"), this.i18n.tr("Description"), this.i18n.tr("IP addresses"), this.i18n.tr("MAC address"), this.i18n.tr("NIC vendor"), this.i18n.tr("VLAN"), this.i18n.tr("MTU"), this.i18n.tr("Speed"), this.i18n.tr("Max speed"), this.i18n.tr("Utilization"), this.i18n.tr("Type"), this.i18n.tr("Location"), this.i18n.tr("Admin state"), this.i18n.tr("Oper state"), this.i18n.tr("Expected state"), this.i18n.tr("STP state"), this.i18n.tr("Status"), this.i18n.tr("OSPF area"), this.i18n.tr("OSPF type"), this.i18n.tr("OSPF state"), this.i18n.tr("802.1x PAE"), this.i18n.tr("802.1x backend"), this.i18n.tr("Peer node"), this.i18n.tr("Peer interface"), this.i18n.tr("Peer MAC"), this.i18n.tr("Peer NIC vendor"), this.i18n.tr("Peer IP"), this.i18n.tr("Peer discovery protocol"), this.i18n.tr("Peer last updated")};
        int[] widths = new int[]{150, 60, 150, 150, 70, 150, 100, 70, 90, 150, 100, 100, 90, 120, 200, 80, 80, 80, 80, 150, 150, 100, 120, 90, 80, 80, 80, 80, 80, 80, 80, 80, 120};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 2, 128, 65538);
        this.labelProvider = new InterfaceListLabelProvider((TableViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new InterfaceListComparator());
        this.filter = new InterfaceListFilter();
        ((InterfaceListFilter)this.filter).setHideSubInterfaces(this.hideSubInterfaces);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"InterfacesView.TableViewer");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.mainArea.layout(true, true);
    }

    protected void createActions() {
        super.createActions();
        this.actionCopyMacAddressToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyIpAddressToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyPeerNameToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyPeerMacToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyPeerIpToClipboard = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionCopyMacAddressToClipboard);
        manager.add((IAction)this.actionCopyIpAddressToClipboard);
        manager.add((IAction)this.actionCopyPeerNameToClipboard);
        manager.add((IAction)this.actionCopyPeerMacToClipboard);
        manager.add((IAction)this.actionCopyPeerIpToClipboard);
        manager.add((IAction)this.actionExportToCsv);
    }

    private void copyMacAddress(boolean peerMacAddress) {
        List selection = this.viewer.getStructuredSelection().toList();
        if (selection.size() > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selection.size(); ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                MacAddress addr = null;
                addr = peerMacAddress ? this.labelProvider.getPeerMacAddress((Interface)selection.get(i)) : ((Interface)selection.get(i)).getMacAddress();
                sb.append(addr != null ? addr.toString() : "");
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    public void refresh() {
        if (this.getObject() != null) {
            long[] idList = this.getObject().getChildIdList();
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            this.viewer.setInput((Object)new Interface[0]);
        }
    }

    public void hideSubInterfaces(boolean hide) {
        this.hideSubInterfaces = hide;
        ((InterfaceListFilter)this.filter).setHideSubInterfaces(hide);
        this.viewer.refresh();
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof Interface && object.isChildOf(this.getObjectId());
    }

    protected void onObjectChange(AbstractObject object) {
        this.labelProvider.setNode(object);
        super.onObjectChange(object);
    }

    protected boolean showNodeColumn() {
        return false;
    }

    protected void collectObjectsForChildrenSync(AbstractObject object, Set<AbstractObject> objectsForSync) {
        super.collectObjectsForChildrenSync(object, objectsForSync);
        for (AbstractObject o : object.getAllChildren(3)) {
            AbstractObject peerNode = this.session.findObjectById(((Interface)o).getPeerNodeId());
            if (peerNode == null || peerNode.areChildrenSynchronized()) continue;
            objectsForSync.add(peerNode);
        }
    }

    public boolean isValidForContext(Object context) {
        return context != null && (context instanceof Circuit || context instanceof Node);
    }

    protected void setContext(Object context) {
        if (this.getContext() == null || !context.getClass().equals(this.getContext().getClass())) {
            if (context instanceof Node) {
                this.viewer.getColumnById(0).setWidth(0);
                this.viewer.getColumnById(0).setResizable(false);
            } else {
                this.viewer.getColumnById(0).setResizable(true);
                this.viewer.getColumnById(0).setWidth(150);
            }
        }
        super.setContext(context);
    }

    private void updateColumns() {
        if (this.getContext() instanceof Node) {
            this.viewer.getColumnById(0).setWidth(0);
            this.viewer.getColumnById(0).setResizable(false);
        } else {
            this.viewer.getColumnById(0).setResizable(true);
            this.viewer.getColumnById(0).setWidth(150);
        }
    }
}

