/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Subnet;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.SubnetAddressMap;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;

public class AddressMapView
extends ObjectView {
    private ScrolledComposite scroller;
    private SubnetAddressMap addressMap;

    public AddressMapView() {
        super(LocalizationHelper.getI18n(AddressMapView.class).tr("Address map"), ResourceManager.getImageDescriptor((String)"icons/object-views/address_map.png"), "objects.address-map", false);
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.refresh();
    }

    public int getPriority() {
        return 22;
    }

    protected void createContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 768);
        this.addressMap = new SubnetAddressMap((Composite)this.scroller, 0, (ObjectView)this);
        this.scroller.setContent((Control)this.addressMap);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addressMap.setUpdateListener(() -> this.scroller.setMinSize(this.addressMap.computeSize(-1, -1)));
    }

    protected void onObjectChange(AbstractObject object) {
        if (object != null && this.isActive()) {
            this.refresh();
        }
    }

    public void activate() {
        super.activate();
        this.refresh();
    }

    public void refresh() {
        this.addressMap.setSubnet((Subnet)this.getObject());
    }

    public boolean isValidForContext(Object context) {
        return context instanceof Subnet;
    }
}

