/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.configs.CustomAttribute;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.AttributeEditDialog;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.helpers.AttrListLabelProvider;
import org.netxms.nxmc.tools.ElementLabelComparator;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class CustomAttributes
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(CustomAttributes.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_INHERITABLE = 2;
    public static final int COLUMN_INHERETED_FROM = 3;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Map<String, CustomAttribute> attributes = null;
    private boolean isModified = false;

    public CustomAttributes(AbstractObject object) {
        super(LocalizationHelper.getI18n(CustomAttributes.class).tr("Custom Attributes"), object);
    }

    public String getId() {
        return "customAttributes";
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{this.i18n.tr("Name"), this.i18n.tr("Value"), this.i18n.tr("Inheritable"), this.i18n.tr("Origin")};
        int[] columnWidths = new int[]{150, 250, 80, 250};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        AttrListLabelProvider labelProvider = new AttrListLabelProvider(this.object);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)labelProvider));
        this.attributes = new HashMap(this.object.getCustomAttributes());
        this.viewer.setInput(this.attributes.entrySet());
        if (!PreferenceStore.getInstance().getAsBoolean("CustomAttributes.ShowHidden", false)) {
            this.viewer.addFilter((ViewerFilter)new /* Unavailable Anonymous Inner Class!! */);
        }
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(this.i18n.tr("&Modify..."));
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(this.i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void addAttribute() {
        AttributeEditDialog dlg = new AttributeEditDialog(this.getShell(), null, null, 0L, 0L);
        if (dlg.open() != 0) {
            return;
        }
        if (this.attributes.containsKey(dlg.getName())) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)String.format(this.i18n.tr("Attribute named %s already exists"), dlg.getName()));
        } else {
            this.attributes.put(dlg.getName(), new CustomAttribute(dlg.getValue(), dlg.getFlags(), 0L));
            this.viewer.setInput(this.attributes.entrySet());
            this.isModified = true;
        }
    }

    private void editAttribute() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry element = (Map.Entry)selection.getFirstElement();
        CustomAttribute attr = (CustomAttribute)element.getValue();
        AttributeEditDialog dlg = new AttributeEditDialog(this.getShell(), (String)element.getKey(), attr.getValue(), attr.getFlags(), attr.getSourceObject());
        if (dlg.open() == 0) {
            this.attributes.put(dlg.getName(), new CustomAttribute(dlg.getValue(), dlg.getFlags(), attr.getSourceObject()));
            this.viewer.setInput(this.attributes.entrySet());
            this.isModified = true;
        }
    }

    private void deleteAttributes() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        boolean modified = false;
        while (it.hasNext()) {
            Map.Entry element = (Map.Entry)it.next();
            if (((CustomAttribute)element.getValue()).isInherited() && !((CustomAttribute)element.getValue()).isRedefined()) continue;
            if (((CustomAttribute)element.getValue()).isRedefined()) {
                CustomAttribute ca;
                CustomAttribute parentCa = null;
                AbstractObject parentObject = null;
                HashSet<Long> objectSet = new HashSet<Long>();
                for (AbstractObject obj : this.object.getParentsAsArray()) {
                    ca = obj.getCustomAttribute((String)element.getKey());
                    if (((CustomAttribute)element.getValue()).getSourceObject() == obj.getObjectId()) {
                        if (ca != null && ca.isInheritable()) {
                            parentCa = ca;
                            parentObject = obj;
                        }
                        objectSet.add(obj.getObjectId());
                        continue;
                    }
                    if (ca == null || !ca.isInheritable()) continue;
                    objectSet.add(obj.getObjectId());
                }
                if (parentCa == null) {
                    for (AbstractObject obj : this.object.getParentsAsArray()) {
                        ca = obj.getCustomAttribute((String)element.getKey());
                        if (ca == null || !ca.isInheritable()) continue;
                        parentCa = ca;
                        parentObject = obj;
                        break;
                    }
                }
                if (parentCa == null) {
                    this.attributes.remove(element.getKey());
                } else {
                    this.attributes.put((String)element.getKey(), new CustomAttribute(parentCa.getValue(), objectSet.size() > 1 ? 5L : 1L, parentCa.isInherited() && !parentCa.isRedefined() ? parentCa.getSourceObject() : parentObject.getObjectId()));
                }
                modified = true;
                continue;
            }
            this.attributes.remove(element.getKey());
            modified = true;
        }
        if (modified) {
            this.viewer.setInput(this.attributes.entrySet());
            this.isModified = true;
        }
    }

    protected boolean applyChanges(boolean isApply) {
        if (!this.isModified) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setCustomAttributes(this.attributes);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

