/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.PortStopEntry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class PortStopEntryDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(PortStopEntryDialog.class);
    private PortStopEntry entry;
    private Spinner portSpinner;
    private Combo protocolCombo;

    public PortStopEntryDialog(Shell parentShell, PortStopEntry entry) {
        super(parentShell);
        this.entry = entry;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.entry == null ? this.i18n.tr("Add Port Stop Entry") : this.i18n.tr("Edit Port Stop Entry"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("Port:"));
        this.portSpinner = new Spinner(dialogArea, 2048);
        this.portSpinner.setMinimum(1);
        this.portSpinner.setMaximum(65535);
        this.portSpinner.setSelection(this.entry != null ? this.entry.getPort() : 1);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 100;
        this.portSpinner.setLayoutData((Object)gd);
        label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("Protocol:"));
        this.protocolCombo = new Combo(dialogArea, 12);
        this.protocolCombo.add("TCP");
        this.protocolCombo.add("UDP");
        this.protocolCombo.add("TCP/UDP");
        if (this.entry != null) {
            switch (this.entry.getProtocol()) {
                case 'T': {
                    this.protocolCombo.select(0);
                    break;
                }
                case 'U': {
                    this.protocolCombo.select(1);
                    break;
                }
                case 'B': {
                    this.protocolCombo.select(2);
                    break;
                }
                default: {
                    this.protocolCombo.select(2);
                    break;
                }
            }
        } else {
            this.protocolCombo.select(2);
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.protocolCombo.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        int port = this.portSpinner.getSelection();
        if (port < 1 || port > 65535) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Port number must be between 1 and 65535"));
            return;
        }
        char protocol = switch (this.protocolCombo.getSelectionIndex()) {
            case 0 -> 'T';
            case 1 -> 'U';
            default -> 'B';
        };
        if (this.entry == null) {
            this.entry = new PortStopEntry(port, protocol);
        } else {
            this.entry.setPort(port);
            this.entry.setProtocol(protocol);
        }
        super.okPressed();
    }

    public PortStopEntry getEntry() {
        return this.entry;
    }
}

