/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.MapType;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.propertypages.PropertyDialog;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.modules.imagelibrary.ImageUpdateListener;
import org.netxms.nxmc.modules.imagelibrary.dialogs.ImageSelectionDialog;
import org.netxms.nxmc.modules.networkmaps.algorithms.ManualLayout;
import org.netxms.nxmc.modules.networkmaps.dialogs.EditGroupBoxDialog;
import org.netxms.nxmc.modules.networkmaps.propertypages.DCIContainerDataSources;
import org.netxms.nxmc.modules.networkmaps.propertypages.DCIContainerGeneral;
import org.netxms.nxmc.modules.networkmaps.propertypages.DCIImageGeneral;
import org.netxms.nxmc.modules.networkmaps.propertypages.DCIImageRules;
import org.netxms.nxmc.modules.networkmaps.propertypages.LinkColor;
import org.netxms.nxmc.modules.networkmaps.propertypages.LinkDataSources;
import org.netxms.nxmc.modules.networkmaps.propertypages.LinkGeneral;
import org.netxms.nxmc.modules.networkmaps.propertypages.TextBoxGeneral;
import org.netxms.nxmc.modules.networkmaps.views.AbstractNetworkMapView;
import org.netxms.nxmc.modules.networkmaps.views.PredefinedMapView;
import org.netxms.nxmc.modules.networkmaps.views.helpers.LinkEditor;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapObjectSyncer;
import org.netxms.nxmc.modules.objects.ObjectPropertiesManager;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class PredefinedMapView
extends AbstractNetworkMapView
implements ImageUpdateListener {
    private final I18n i18n = LocalizationHelper.getI18n(PredefinedMapView.class);
    private Action actionAddObject;
    private Action actionAddObjectMenu;
    private Action actionAddDCIContainer;
    private Action actionLinkObjects;
    private Action actionAddGroupBox;
    private Action actionAddImage;
    private Action actionRemove;
    private Action actionDCIContainerProperties;
    private Action actionDCIImageProperties;
    private Action actionMapProperties;
    private Action actionLinkProperties;
    private Action actionAddDCIImage;
    private Action actionAddTextBox;
    private Action actionTextBoxProperties;
    private Action actionGroupBoxProperties;
    private Action actionImageProperties;
    private Action actionAutoLinkNodes;
    private Color defaultLinkColor = null;
    private boolean disableGeolocationBackground = false;
    private boolean disableLinkTextAutoUpdate = true;
    private Map<Long, Boolean> readOnlyFlagsCache = new HashMap();
    private Set<NetworkMapElement> movedElementList = new HashSet();
    private Set<NetworkMapLink> changedLinkList = new HashSet();
    private MapObjectSyncer mapObjectSyncer = null;
    private int mapWidth;
    private int mapHeight;
    private int updateWarningId = 0;

    public PredefinedMapView() {
        super(LocalizationHelper.getI18n(PredefinedMapView.class).tr("Map"), ResourceManager.getImageDescriptor((String)"icons/object-views/netmap.png"), "objects.predefined-map");
    }

    protected PredefinedMapView(String id) {
        super(LocalizationHelper.getI18n(PredefinedMapView.class).tr("Map"), ResourceManager.getImageDescriptor((String)"icons/object-views/netmap.png"), id);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof NetworkMap;
    }

    public int getPriority() {
        return 1;
    }

    protected void contextChanged(Object oldContext, Object newContext) {
        if (this.bendpointEditor != null) {
            this.bendpointEditor.stop();
        }
        this.viewer.resetRefreshBlock();
        this.saveObjectPositions();
        if (oldContext != null) {
            this.saveZoom((AbstractObject)oldContext);
        }
        this.updateWarningId = 0;
        super.contextChanged(oldContext, newContext);
    }

    protected void onObjectChange(AbstractObject object) {
        Boolean cachedFlag = (Boolean)this.readOnlyFlagsCache.get(object.getObjectId());
        this.actionLock.setChecked(true);
        this.lockObjectMove(true);
        if (cachedFlag != null) {
            this.readOnly = cachedFlag;
            this.reconfigureViewer();
            this.syncObjects();
        } else {
            this.readOnly = true;
            1 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
        }
        this.loadZoom(object);
        this.updateWarningMessage(object);
    }

    protected void onObjectUpdate(AbstractObject object) {
        if (this.viewer.isRefreshBlocked()) {
            return;
        }
        this.saveObjectPositions();
        super.onObjectUpdate(object);
        this.reconfigureViewer((NetworkMap)object);
        this.syncObjects();
        this.updateWarningMessage(object);
    }

    private void updateWarningMessage(AbstractObject object) {
        if (((NetworkMap)object).isUpdateFailed()) {
            if (this.updateWarningId == 0) {
                this.updateWarningId = this.addMessage(2, this.i18n.tr("Automatic map updates temporary disabled because topology information is not available for at least one of the seeds"), true);
            }
        } else if (this.updateWarningId != 0) {
            this.deleteMessage(this.updateWarningId);
            this.updateWarningId = 0;
        }
    }

    private void reconfigureViewer(NetworkMap mapObject) {
        int height;
        this.mapWidth = mapObject.getWidth();
        this.mapHeight = mapObject.getHeight();
        int width = this.mapWidth == 0 ? this.session.getNetworkMapDefaultWidth() : this.mapWidth;
        int n = height = this.mapHeight == 0 ? this.session.getNetworkMapDefaultHeight() : this.mapHeight;
        if (mapObject.isFitToScreen()) {
            this.setMapSize(-1, -1);
        } else {
            this.setMapSize(width, height);
        }
        if (mapObject.getBackground() != null && mapObject.getBackground().compareTo(NXCommon.EMPTY_GUID) != 0) {
            if (mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
                if (!this.disableGeolocationBackground) {
                    this.viewer.setBackgroundImage(mapObject.getBackgroundLocation(), mapObject.getBackgroundZoom());
                }
            } else {
                Image backgroundImage = ImageProvider.getInstance().getImage(mapObject.getBackground());
                if (backgroundImage != null && !mapObject.isFitBackgroundImage()) {
                    Rectangle bounds = backgroundImage.getBounds();
                    if (this.mapWidth == 0 && width < bounds.width) {
                        width = bounds.width;
                    }
                    if (this.mapHeight == 0 && height < bounds.height) {
                        height = bounds.height;
                    }
                }
                this.viewer.setBackgroundImage(backgroundImage, mapObject.isCenterBackgroundImage(), mapObject.isFitBackgroundImage());
            }
        } else {
            this.viewer.setBackgroundImage(null, false, false);
        }
        this.viewer.setBackgroundColor(ColorConverter.rgbFromInt((int)mapObject.getBackgroundColor()));
        this.setConnectionRouter(mapObject.getDefaultLinkRouting(), false);
        if (this.defaultLinkColor != null) {
            this.defaultLinkColor.dispose();
        }
        this.defaultLinkColor = mapObject.getDefaultLinkColor() >= 0 ? new Color((Device)this.viewer.getControl().getDisplay(), ColorConverter.rgbFromInt((int)mapObject.getDefaultLinkColor())) : null;
        this.labelProvider.setDefaultLinkColor(this.defaultLinkColor);
        if (mapObject.getLayout() == MapLayoutAlgorithm.MANUAL) {
            this.automaticLayoutEnabled = false;
            this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new ManualLayout());
        } else {
            this.automaticLayoutEnabled = true;
            this.layoutAlgorithm = mapObject.getLayout();
            this.setLayoutAlgorithm(this.layoutAlgorithm, true);
        }
        this.setObjectDisplayMode(mapObject.getObjectDisplayMode(), false);
        this.labelProvider.setShowStatusBackground(mapObject.isShowStatusBackground());
        this.labelProvider.setShowStatusFrame(mapObject.isShowStatusFrame());
        this.labelProvider.setShowStatusIcons(mapObject.isShowStatusIcon());
        this.labelProvider.setShowLinkDirection(mapObject.isShowLinkDirection());
        this.labelProvider.setTranslucentLabelBackground(mapObject.isTranslucentLabelBackground());
        this.labelProvider.setDefaultLinkStyle(mapObject.getDefaultLinkStyle());
        this.labelProvider.setDefaultLinkWidth(mapObject.getDefaultLinkWidth());
        this.actionShowStatusBackground.setChecked(this.labelProvider.isShowStatusBackground());
        this.actionShowStatusFrame.setChecked(this.labelProvider.isShowStatusFrame());
        this.actionShowStatusIcon.setChecked(this.labelProvider.isShowStatusIcons());
        this.actionShowLinkDirection.setChecked(this.labelProvider.isShowLinkDirection());
        this.actionTranslucentLabelBkgnd.setChecked(this.labelProvider.isTranslucentLabelBackground());
        for (int i = 0; i < this.actionSetAlgorithm.length; ++i) {
            this.actionSetAlgorithm[i].setEnabled(this.automaticLayoutEnabled);
        }
        this.actionEnableAutomaticLayout.setChecked(this.automaticLayoutEnabled);
    }

    private void reconfigureViewer() {
        this.allowManualLayout = !this.readOnly;
        this.viewer.setDraggingEnabled(!this.readOnly && !this.objectMoveLocked);
        NetworkMap mapObject = this.getMapObject();
        if (mapObject == null) {
            return;
        }
        this.reconfigureViewer(mapObject);
        this.labelProvider.updateMapId(this.getMapObject().getObjectId());
    }

    public void setupMapControl() {
        if (this.mapObjectSyncer == null) {
            this.mapObjectSyncer = MapObjectSyncer.getInstance();
        }
        this.viewer.addPostSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addDropSupport();
        ImageProvider.getInstance().addUpdateListener((ImageUpdateListener)this);
        this.reconfigureViewer();
    }

    private void addDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDropSupport(3, transfers, (DropTargetListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void buildMapPage(NetworkMapPage oldMapPage) {
        NetworkMap mapObject = this.getMapObject();
        if (mapObject != null) {
            this.disableLinkTextAutoUpdate = mapObject.isDontUpdateLinkText();
            this.mapPage = mapObject.createMapPage();
        } else {
            this.mapPage = new NetworkMapPage("EMPTY");
        }
        this.refreshDciRequestList(oldMapPage, true);
    }

    private void syncObjects() {
        NetworkMap mapObject = this.getMapObject();
        NetworkMapPage page = mapObject.createMapPage();
        HashSet mapObjectIds = new HashSet(page.getObjectIds());
        HashSet mapUtilizationObjets = new HashSet();
        page.getAllLinkStatusAndUtilizationObjects(mapObjectIds, mapUtilizationObjets);
        this.removeResyncNodes();
        4 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void removeResyncNodes() {
        if (this.mapPage == null) {
            return;
        }
        HashSet mapObjectIds = new HashSet(this.mapPage.getObjectIds());
        mapObjectIds.addAll(this.mapPage.getAllLinkStatusObjects());
        if (this.mapObjectSyncer != null) {
            this.mapObjectSyncer.removeObjects(this.mapPage.getMapObjectId(), mapObjectIds);
        }
    }

    protected void createActions() {
        super.createActions();
        this.actionAddObject = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M3+A", (IAction)this.actionAddObject);
        this.actionAddObjectMenu = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddDCIContainer = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M3+C", (IAction)this.actionAddDCIContainer);
        this.actionAddDCIImage = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddGroupBox = new /* Unavailable Anonymous Inner Class!! */;
        this.actionGroupBoxProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddImage = new /* Unavailable Anonymous Inner Class!! */;
        this.actionImageProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLinkObjects = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+L", (IAction)this.actionLinkObjects);
        this.actionAutoLinkNodes = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRemove = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+R", (IAction)this.actionRemove);
        this.actionDCIContainerProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDCIImageProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMapProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLinkProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddTextBox = new /* Unavailable Anonymous Inner Class!! */;
        this.actionTextBoxProperties = new /* Unavailable Anonymous Inner Class!! */;
    }

    private IMenuManager createDecorationAdditionSubmenu() {
        MenuManager menu = new MenuManager(this.i18n.tr("Add &decoration"));
        menu.add((IAction)this.actionAddGroupBox);
        menu.add((IAction)this.actionAddImage);
        menu.add((IAction)this.actionAddTextBox);
        return menu;
    }

    protected void fillMapContextMenu(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionAddObjectMenu);
            manager.add((IAction)this.actionAddDCIContainer);
            manager.add((IAction)this.actionAddDCIImage);
            manager.add((IContributionItem)this.createDecorationAdditionSubmenu());
            manager.add((IContributionItem)new Separator());
        }
        super.fillMapContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionMapProperties);
    }

    protected void fillObjectContextMenu(IMenuManager manager, boolean isPartial) {
        if (!this.readOnly) {
            int size = this.viewer.getStructuredSelection().size();
            if (size >= 2) {
                manager.add((IAction)this.actionLinkObjects);
            }
            if (size >= 2 && this.getMapObject().getMapType() == MapType.CUSTOM) {
                manager.add((IAction)this.actionAutoLinkNodes);
            }
            manager.add((IAction)this.actionRemove);
            manager.add((IContributionItem)new Separator());
        }
        super.fillObjectContextMenu(manager, isPartial);
    }

    protected void fillLinkContextMenu(IMenuManager manager) {
        if (this.readOnly) {
            super.fillLinkContextMenu(manager);
            return;
        }
        int size = this.viewer.getStructuredSelection().size();
        super.fillLinkContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRemove);
        if (size == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionLinkProperties);
        }
    }

    protected void fillElementContextMenu(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionRemove);
            Object o = this.viewer.getStructuredSelection().getFirstElement();
            if (o instanceof NetworkMapDCIContainer) {
                manager.add((IAction)this.actionDCIContainerProperties);
            } else if (o instanceof NetworkMapDCIImage) {
                manager.add((IAction)this.actionDCIImageProperties);
            } else if (o instanceof NetworkMapTextBox) {
                manager.add((IAction)this.actionTextBoxProperties);
            } else if (o instanceof NetworkMapDecoration) {
                manager.add((IAction)(((NetworkMapDecoration)o).getDecorationType() == 1 ? this.actionImageProperties : this.actionGroupBoxProperties));
            }
            manager.add((IContributionItem)new Separator());
        }
        super.fillElementContextMenu(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionAddObject);
            manager.add((IAction)this.actionLinkObjects);
            manager.add((IContributionItem)this.createDecorationAdditionSubmenu());
            manager.add((IContributionItem)new Separator());
        }
        super.fillLocalMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionMapProperties);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionAddObject);
            manager.add((IAction)this.actionLinkObjects);
            manager.add((IContributionItem)new Separator());
        }
        super.fillLocalToolBar(manager);
    }

    protected void saveLayout() {
        this.saveMap();
    }

    private void addObjectToMap(boolean useRightClickLocation) {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        this.addObjectsFromList(dlg.getSelectedObjects(), useRightClickLocation ? this.viewer.getRightClickLocation() : null);
    }

    private void addObjectsFromList(List<AbstractObject> list, Point location) {
        int added = 0;
        for (AbstractObject object : list) {
            if (this.mapPage.findObjectElement(object.getObjectId()) != null) continue;
            NetworkMapObject mapObject = new NetworkMapObject(this.mapPage.createElementId(), object.getObjectId());
            if (location != null) {
                mapObject.setLocation(location.x, location.y);
            } else {
                mapObject.setLocation(40, 40);
            }
            this.mapPage.addElement((NetworkMapElement)mapObject);
            ++added;
        }
        if (added > 0) {
            this.saveMap();
        }
    }

    private void removeSelectedElements() {
        Object[] objects;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Confirm Removal"), (String)(selection.size() == 1 ? this.i18n.tr("Are you sure to remove selected element from map?") : this.i18n.tr("Are you sure to remove selected elements from map?")))) {
            return;
        }
        for (Object element : objects = selection.toArray()) {
            if (element instanceof AbstractObject) {
                this.mapPage.removeObjectElement(((AbstractObject)element).getObjectId());
                continue;
            }
            if (element instanceof NetworkMapElement) {
                this.mapPage.removeElement(((NetworkMapElement)element).getId());
                continue;
            }
            if (!(element instanceof NetworkMapLink)) continue;
            this.mapPage.removeLink((NetworkMapLink)element);
        }
        this.saveMap();
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    protected void updateMapSize(int width, int height) {
        this.mapWidth = width;
        this.mapHeight = height;
        super.updateMapSize(width, height);
    }

    private void saveMap() {
        this.updateObjectPositions();
        NXCObjectModificationData md = new NXCObjectModificationData(this.getMapObject().getObjectId());
        md.setMapContent(this.mapPage.getElements(), this.mapPage.getLinks());
        md.setMapLayout(this.automaticLayoutEnabled ? this.layoutAlgorithm : MapLayoutAlgorithm.MANUAL);
        md.setConnectionRouting(this.routingAlgorithm);
        md.setMapObjectDisplayMode(this.labelProvider.getObjectFigureType());
        md.setMapSize(this.mapWidth, this.mapHeight);
        int flags = this.getMapObject().getFlags();
        flags = this.labelProvider.isShowStatusIcons() ? (flags |= 1) : (flags &= 0xFFFFFFFE);
        flags = this.labelProvider.isShowStatusFrame() ? (flags |= 2) : (flags &= 0xFFFFFFFD);
        flags = this.labelProvider.isShowStatusBackground() ? (flags |= 4) : (flags &= 0xFFFFFFFB);
        flags = this.labelProvider.isShowLinkDirection() ? (flags |= 0x40) : (flags &= 0xFFFFFFBF);
        flags = this.labelProvider.isTranslucentLabelBackground() ? (flags |= 0x200) : (flags &= 0xFFFFFDFF);
        md.setObjectFlags((long)flags);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void showMapProperties() {
        this.updateObjectPositions();
        ObjectPropertiesManager.openObjectPropertiesDialog((AbstractObject)this.getMapObject(), (Shell)this.getWindow().getShell(), (MessageAreaHolder)this);
    }

    protected boolean isSelectableElement(Object element) {
        return element instanceof NetworkMapDecoration || element instanceof NetworkMapLink || element instanceof NetworkMapDCIContainer || element instanceof NetworkMapDCIImage || element instanceof NetworkMapTextBox;
    }

    public void imageUpdated(UUID guid) {
        if (guid.equals(this.getMapObject().getBackground())) {
            this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(guid), this.getMapObject().isCenterBackgroundImage(), this.getMapObject().isFitBackgroundImage());
        }
        String guidText = guid.toString();
        for (NetworkMapElement e : this.mapPage.getElements()) {
            if (!(e instanceof NetworkMapDecoration) || ((NetworkMapDecoration)e).getDecorationType() != 1 || !((NetworkMapDecoration)e).getTitle().equals(guidText)) continue;
            this.viewer.updateDecorationFigure((NetworkMapElement)((NetworkMapDecoration)e));
            break;
        }
    }

    public void dispose() {
        ImageProvider imageProvider = ImageProvider.getInstance();
        if (imageProvider != null) {
            imageProvider.removeUpdateListener((ImageUpdateListener)this);
        }
        if (this.defaultLinkColor != null) {
            this.defaultLinkColor.dispose();
        }
        this.removeResyncNodes();
        this.mapObjectSyncer = null;
        super.dispose();
    }

    private boolean updateElement(NetworkMapElement element) {
        if (this.mapPage.updateElement(element)) {
            this.saveMap();
            return true;
        }
        this.addMessage(3, this.i18n.tr("Failed to update map element: the object no longer exists"));
        return false;
    }

    private void addDCIContainer() {
        NetworkMapDCIContainer dciContainer = new NetworkMapDCIContainer(this.mapPage.createElementId());
        if (this.showDCIContainerProperties(dciContainer)) {
            this.mapPage.addElement((NetworkMapElement)dciContainer);
            this.fullDciCacheRefresh();
            this.saveMap();
        }
    }

    private void editDCIContainer() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDCIContainer)) {
            return;
        }
        NetworkMapDCIContainer dciContainer = (NetworkMapDCIContainer)selection.getFirstElement();
        if (this.showDCIContainerProperties(dciContainer) && this.updateElement((NetworkMapElement)dciContainer)) {
            this.fullDciCacheRefresh();
            this.saveMap();
        }
    }

    private boolean showDCIContainerProperties(NetworkMapDCIContainer container) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("dciContainer.general", (IPreferencePage)new DCIContainerGeneral(container)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("dciContainer.dataSources", (IPreferencePage)new DCIContainerDataSources(container)));
        PropertyDialog dlg = new PropertyDialog(this.getWindow().getShell(), pm, this.i18n.tr("DCI Container Properties"));
        return dlg.open() == 0;
    }

    private void addDCIImage() {
        NetworkMapDCIImage dciImage = new NetworkMapDCIImage(this.mapPage.createElementId());
        if (this.showDCIImageProperties(dciImage)) {
            this.fullDciCacheRefresh();
            this.mapPage.addElement((NetworkMapElement)dciImage);
            this.saveMap();
        }
    }

    private void editDCIImage() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDCIImage)) {
            return;
        }
        NetworkMapDCIImage dciImage = (NetworkMapDCIImage)selection.getFirstElement();
        if (this.showDCIImageProperties(dciImage) && this.updateElement((NetworkMapElement)dciImage)) {
            this.fullDciCacheRefresh();
            this.saveMap();
        }
    }

    private boolean showDCIImageProperties(NetworkMapDCIImage dciImage) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("dciImage.general", (IPreferencePage)new DCIImageGeneral(dciImage)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("dciImage.rules", (IPreferencePage)new DCIImageRules(dciImage)));
        PropertyDialog dlg = new PropertyDialog(this.getWindow().getShell(), pm, this.i18n.tr("DCI Image Properties"));
        return dlg.open() == 0;
    }

    private void linkSelectedObjects() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 2) {
            return;
        }
        Object[] objects = selection.toArray();
        long id1 = ((NetworkMapObject)objects[0]).getId();
        long id2 = ((NetworkMapObject)objects[1]).getId();
        this.mapPage.addLink(new NetworkMapLink(this.mapPage.createLinkId(), 0, id1, id2));
        this.saveMap();
    }

    private void autoLinkSelectedObjects() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() < 2) {
            return;
        }
        ArrayList<Long> nodes = new ArrayList<Long>(selection.size());
        for (Object object : selection.toList()) {
            if (!(object instanceof NetworkMapObject)) continue;
            nodes.add(((NetworkMapObject)object).getObjectId());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void showLinkProperties() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapLink)) {
            return;
        }
        LinkEditor link = new LinkEditor((NetworkMapLink)selection.getFirstElement(), this.mapPage, this.disableLinkTextAutoUpdate);
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("link.general", (IPreferencePage)new LinkGeneral(link)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("link.color", (IPreferencePage)new LinkColor(link)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("link.dataSources", (IPreferencePage)new LinkDataSources(link)));
        24 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        dlg.open();
        if (link.isModified()) {
            if (link.getRoutingAlgorithm() != 3 && this.bendpointEditor != null) {
                this.bendpointEditor.stop();
                this.bendpointEditor = null;
            }
            if (link.update(this.mapPage)) {
                this.fullDciCacheRefresh();
                this.saveMap();
            } else {
                this.addMessage(3, this.i18n.tr("Failed to update link: the object no longer exists"));
            }
        }
    }

    private void addTextBox() {
        NetworkMapTextBox textBox = new NetworkMapTextBox(this.mapPage.createElementId());
        if (this.showTextBoxProperties(textBox)) {
            this.mapPage.addElement((NetworkMapElement)textBox);
            this.saveMap();
        }
    }

    private void editTextBox() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapTextBox)) {
            return;
        }
        NetworkMapTextBox textBox = (NetworkMapTextBox)selection.getFirstElement();
        if (this.showTextBoxProperties(textBox) && this.updateElement((NetworkMapElement)textBox)) {
            this.saveMap();
        }
    }

    private boolean showTextBoxProperties(NetworkMapTextBox textBox) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("textbox.general", (IPreferencePage)new TextBoxGeneral(textBox)));
        PropertyDialog dlg = new PropertyDialog(this.getWindow().getShell(), pm, this.i18n.tr("Text Box Properties"));
        return dlg.open() == 0;
    }

    private void addImageDecoration() {
        ImageSelectionDialog dlg = new ImageSelectionDialog(this.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        UUID imageGuid = dlg.getImageGuid();
        Rectangle imageBounds = ImageProvider.getInstance().getImage(imageGuid).getBounds();
        NetworkMapDecoration element = new NetworkMapDecoration(this.mapPage.createElementId(), 1);
        element.setSize(imageBounds.width, imageBounds.height);
        element.setTitle(imageGuid.toString());
        this.mapPage.addElement((NetworkMapElement)element);
        this.saveMap();
    }

    private void editImageDecoration() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDecoration)) {
            return;
        }
        ImageSelectionDialog dlg = new ImageSelectionDialog(this.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        UUID imageGuid = dlg.getImageGuid();
        Rectangle imageBounds = ImageProvider.getInstance().getImage(imageGuid).getBounds();
        NetworkMapDecoration element = (NetworkMapDecoration)selection.getFirstElement();
        element.setSize(imageBounds.width, imageBounds.height);
        element.setTitle(imageGuid.toString());
        this.mapPage.addElement((NetworkMapElement)element);
        this.saveMap();
    }

    private void addGroupBox() {
        NetworkMapDecoration element = new NetworkMapDecoration(this.mapPage.createElementId(), 0);
        EditGroupBoxDialog dlg = new EditGroupBoxDialog(this.getWindow().getShell(), element);
        if (dlg.open() != 0) {
            return;
        }
        this.mapPage.addElement((NetworkMapElement)element);
        this.saveMap();
    }

    private void editGroupBox() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDecoration)) {
            return;
        }
        NetworkMapDecoration groupBox = (NetworkMapDecoration)selection.getFirstElement();
        EditGroupBoxDialog dlg = new EditGroupBoxDialog(this.getWindow().getShell(), groupBox);
        if (dlg.open() == 0) {
            this.mapPage.addElement((NetworkMapElement)groupBox);
            this.saveMap();
        }
    }

    protected NetworkMap getMapObject() {
        return (NetworkMap)this.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onElementMove(NetworkMapElement element) {
        if (!this.allowManualLayout) {
            return;
        }
        Set set = this.movedElementList;
        synchronized (set) {
            this.movedElementList.add(element);
            if (!this.saveSchedulted) {
                this.saveSchedulted = true;
                this.getDisplay().timerExec(1000, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLinkChange(NetworkMapLink link) {
        Set set = this.movedElementList;
        synchronized (set) {
            this.changedLinkList.add(link);
            if (!this.saveSchedulted) {
                this.saveSchedulted = true;
                this.getDisplay().timerExec(1000, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public void refresh() {
        if (this.viewer.isRefreshBlocked()) {
            return;
        }
        this.saveObjectPositions();
        super.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveObjectPositions() {
        Set linkListLocalCopy;
        Set elementListLocalCopy;
        if (!this.saveSchedulted) {
            return;
        }
        Set set = this.movedElementList;
        synchronized (set) {
            this.saveSchedulted = false;
            elementListLocalCopy = this.movedElementList;
            this.movedElementList = new HashSet();
            linkListLocalCopy = this.changedLinkList;
            this.changedLinkList = new HashSet();
        }
        if (elementListLocalCopy.size() > 0) {
            this.updateObjectPositions();
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void saveZoom(AbstractObject object) {
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set(this.getBaseId() + "@" + object.getObjectId() + ".zoom", this.viewer.getZoom());
    }

    protected void loadZoom(AbstractObject object) {
        if (object == null) {
            return;
        }
        PreferenceStore settings = PreferenceStore.getInstance();
        this.viewer.zoomTo(settings.getAsDouble(this.getBaseId() + "@" + object.getObjectId() + ".zoom", 1.0));
    }

    static /* synthetic */ void access$000(PredefinedMapView x0) {
        x0.updateToolBar();
    }

    static /* synthetic */ void access$100(PredefinedMapView x0) {
        x0.updateMenu();
    }

    static /* synthetic */ NXCSession access$200(PredefinedMapView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$300(PredefinedMapView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$400(PredefinedMapView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$500(PredefinedMapView x0) {
        return x0.session;
    }
}

