/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.ScheduledTask;
import org.netxms.client.server.ServerFile;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.ScheduleEditor;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class StartServerToAgentFileUploadDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(StartServerToAgentFileUploadDialog.class);
    private TableViewer fileList;
    private Button buttonAddFile;
    private Button buttonRemoveFile;
    private LabeledText textRemoteFile;
    private Button checkIsSchedule;
    private ScheduleEditor scheduleEditor;
    private List<ServerFile> serverFiles = new ArrayList();
    private String remoteFileName;
    private boolean scheduledTask;
    private ScheduledTask schedule;
    private boolean canScheduleFileUpload;

    public StartServerToAgentFileUploadDialog(Shell parentShell, boolean canScheduleFileUpload) {
        super(parentShell);
        this.canScheduleFileUpload = canScheduleFileUpload;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Start File Upload"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("Server files"));
        this.fileList = new TableViewer(dialogArea, 67586);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        gd.heightHint = 150;
        this.fileList.getControl().setLayoutData((Object)gd);
        this.fileList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fileList.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.fileList.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.fileList.setInput((Object)this.serverFiles);
        Composite buttonArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        buttonArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttonArea.setLayoutData((Object)gd);
        this.buttonAddFile = new Button(buttonArea, 8);
        this.buttonAddFile.setText(this.i18n.tr("&Add..."));
        gd = new GridData();
        gd.widthHint = 90;
        this.buttonAddFile.setLayoutData((Object)gd);
        this.buttonAddFile.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonRemoveFile = new Button(buttonArea, 8);
        this.buttonRemoveFile.setText(this.i18n.tr("&Remove"));
        gd = new GridData();
        gd.widthHint = 90;
        this.buttonRemoveFile.setLayoutData((Object)gd);
        this.buttonRemoveFile.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.textRemoteFile = new LabeledText(dialogArea, 0);
        this.textRemoteFile.setLabel(this.i18n.tr("Remote file name (leave blank for upload to agent's file store)"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textRemoteFile.setLayoutData((Object)gd);
        if (this.canScheduleFileUpload) {
            this.checkIsSchedule = new Button(dialogArea, 32);
            this.checkIsSchedule.setText(this.i18n.tr("Schedule task"));
            this.checkIsSchedule.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.scheduleEditor = new ScheduleEditor(dialogArea, 0);
            this.scheduleEditor.setEnabled(false);
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.scheduledTask = this.checkIsSchedule.getSelection();
        if (this.scheduledTask) {
            this.schedule = this.scheduleEditor.getSchedule();
            this.schedule.setTaskHandlerId("Upload.File");
        }
        if (this.serverFiles.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please select file for upload"));
            return;
        }
        this.remoteFileName = this.textRemoteFile.getText().trim();
        super.okPressed();
    }

    public List<ServerFile> getServerFiles() {
        return this.serverFiles;
    }

    public String getRemoteFileName() {
        return this.remoteFileName;
    }

    public boolean isScheduled() {
        return this.scheduledTask;
    }

    public ScheduledTask getScheduledTask() {
        return this.schedule;
    }
}

