/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.PathElement;
import org.netxms.nxmc.resources.ResourceManager;

public class FileDeliveryPolicyLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image imageFolder = ResourceManager.getImageDescriptor((String)"icons/folder.gif").createImage();
    private Image imageFile = ResourceManager.getImageDescriptor((String)"icons/file.png").createImage();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return ((PathElement)element).isFile() ? this.imageFile : this.imageFolder;
        }
        return null;
    }

    public void dispose() {
        this.imageFile.dispose();
        this.imageFolder.dispose();
        super.dispose();
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((PathElement)element).getName();
            }
            case 1: {
                return ((PathElement)element).getGuid() != null ? ((PathElement)element).getGuid().toString() : null;
            }
            case 2: {
                if (!((PathElement)element).isFile()) {
                    return null;
                }
                return ((PathElement)element).getCreationTime() != null ? DateFormatFactory.getDateTimeFormat().format(((PathElement)element).getCreationTime()) : null;
            }
            case 3: {
                return ((PathElement)element).getOwner();
            }
            case 4: {
                return ((PathElement)element).getOwnerGroup();
            }
            case 5: {
                return ((PathElement)element).getPermissionsAsString();
            }
        }
        return null;
    }
}

