/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.TableRow;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.BaseTableValueViewer;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.CellSelectionManager;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.TableContentProvider;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.TableItemComparator;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.TableLabelProvider;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.TableValueFilter;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public abstract class BaseTableValueViewer
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(BaseTableValueViewer.class);
    protected NXCSession session;
    protected ObjectView view;
    protected String configId;
    protected TableValueFilter filter;
    protected Table currentData = null;
    protected SortableTableViewer viewer;
    protected TableLabelProvider labelProvider;
    protected CLabel errorLabel;
    protected CellSelectionManager cellSelectionManager;
    protected Action actionUseMultipliers;
    protected Action actionShowFilter;
    protected boolean saveTableSettings;
    protected String sortColumn = null;
    protected int sortDirection = 128;

    public BaseTableValueViewer(Composite parent, int style, ObjectView view, String configSubId) {
        this(parent, style, view, configSubId, false);
    }

    public BaseTableValueViewer(Composite parent, int style, ObjectView view, String configSubId, boolean saveTableSettings) {
        super(parent, style);
        this.view = view;
        this.saveTableSettings = saveTableSettings;
        this.setupLocalization();
        this.configId = this.buildConfigId(configSubId);
        this.session = Registry.getSession();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.viewer = new SortableTableViewer((Composite)this, 65538);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.labelProvider = new TableLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.filter = new TableValueFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.cellSelectionManager = new CellSelectionManager(this.viewer);
        PreferenceStore ds = PreferenceStore.getInstance();
        this.labelProvider.setUseMultipliers(ds.getAsBoolean(this.configId + ".useMultipliers", false));
        if (saveTableSettings) {
            this.viewer.getTable().addDisposeListener((DisposeListener & Serializable)e -> WidgetHelper.saveTableViewerSettings((SortableTableViewer)this.viewer, (String)this.configId));
        }
        this.createActions();
        this.createPopupMenu();
    }

    protected abstract void setupLocalization();

    protected String buildConfigId(String configSubId) {
        return "BaseTableValueViewer." + configSubId;
    }

    protected void createActions() {
        this.actionUseMultipliers = new /* Unavailable Anonymous Inner Class!! */;
        this.actionUseMultipliers.setChecked(this.labelProvider.areMultipliersUsed());
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillContextMenu(m));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionUseMultipliers);
        manager.add((IContributionItem)new Separator());
    }

    public void setSortColumn(String columnName, int direction) {
        this.sortColumn = columnName;
        this.sortDirection = direction;
    }

    protected void updateViewer(Table table) {
        if (table == null) {
            if (this.viewer.isInitialized()) {
                this.currentData.deleteAllRows();
                this.viewer.refresh();
            }
            return;
        }
        PreferenceStore ds = PreferenceStore.getInstance();
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 150);
            int columnIndex = 0;
            if (this.sortColumn != null && (columnIndex = table.getColumnIndex(this.sortColumn)) == -1) {
                columnIndex = 0;
            }
            this.viewer.createColumns(names, widths, columnIndex, this.sortDirection);
            if (this.saveTableSettings) {
                WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)this.configId);
            }
            this.viewer.getTable().addDisposeListener((DisposeListener & Serializable)e -> {
                if (this.saveTableSettings) {
                    WidgetHelper.saveTableViewerSettings((SortableTableViewer)this.viewer, (String)this.configId);
                }
                ds.set(this.configId + ".useMultipliers", this.labelProvider.areMultipliersUsed());
            });
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnDataTypes()));
            this.labelProvider.setColumns(table.getColumns());
            this.currentData = table;
            this.viewer.setInput((Object)this.currentData);
        } else {
            this.currentData.deleteAllRows();
            this.currentData.addAll(table);
            this.viewer.refresh();
        }
        if (!this.saveTableSettings) {
            this.viewer.packColumns();
        }
    }

    protected String buildInstanceString(ViewerRow viewerRow) {
        StringBuilder instance = new StringBuilder();
        TableRow row = (TableRow)viewerRow.getElement();
        boolean first = true;
        for (int i = 0; i < this.currentData.getColumnCount(); ++i) {
            TableColumnDefinition cd = this.currentData.getColumnDefinition(i);
            if (!cd.isInstanceColumn()) continue;
            if (!first) {
                instance.append("~~~");
            }
            instance.append(row.getValue(i));
            first = false;
        }
        return instance.toString();
    }

    public String getTitle() {
        return this.currentData != null ? this.currentData.getTitle() : "";
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }

    public Action getActionUseMultipliers() {
        return this.actionUseMultipliers;
    }

    public void refresh(Runnable postRefreshHook) {
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public AbstractViewerFilter getFilter() {
        return this.filter;
    }

    protected void showOverlayMessage(String message) {
        if (this.isDisposed()) {
            return;
        }
        if (this.errorLabel == null) {
            this.viewer.getControl().setVisible(false);
            ((GridData)this.viewer.getControl().getLayoutData()).exclude = true;
            this.errorLabel = new CLabel((Composite)this, 0x1000000);
            this.errorLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        }
        this.errorLabel.setText(message);
        this.layout(true, true);
    }

    protected void hideOverlayMessage() {
        if (this.isDisposed()) {
            return;
        }
        if (this.errorLabel != null) {
            this.errorLabel.dispose();
            this.errorLabel = null;
            ((GridData)this.viewer.getControl().getLayoutData()).exclude = false;
            this.viewer.getControl().setVisible(true);
            this.layout(true, true);
        }
    }

    protected abstract Table readData() throws Exception;

    protected String getNoDataMessage() {
        return null;
    }

    protected abstract String getReadJobName();

    protected abstract String getReadJobErrorMessage();
}

