/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.AppMenuItem;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;

public class MenuItemDialog
extends Dialog {
    boolean isSubMenu;
    AppMenuItem item;
    private Text textName;
    private Text textDescription;
    private Text textCommand;
    private Image icon;
    private Label iconLabel;

    public MenuItemDialog(Shell parentShell, AppMenuItem item) {
        super(parentShell);
        this.isSubMenu = item.isSubMenu();
        this.item = item;
    }

    public MenuItemDialog(Shell parentShell, boolean isSubMenu) {
        super(parentShell);
        this.isSubMenu = isSubMenu;
        this.item = null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.item != null ? "Edit Application Menu Item" : "Create Application Menu Item");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.textName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Name", (String)(this.item != null ? this.item.getName() : ""), (Object)"WidgetHelper::default_layout_data");
        this.textName.getShell().setMinimumSize(300, 0);
        this.textName.setTextLimit(63);
        this.textDescription = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Description", (String)(this.item != null ? this.item.getDescription() : ""), (Object)"WidgetHelper::default_layout_data");
        this.textDescription.getShell().setMinimumSize(300, 0);
        if (!this.isSubMenu) {
            this.textCommand = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Command", (String)(this.item != null ? this.item.getCommand() : ""), (Object)"WidgetHelper::default_layout_data");
            this.textCommand.getShell().setMinimumSize(300, 0);
        }
        this.createIconSelector(dialogArea);
        this.textName.setFocus();
        return dialogArea;
    }

    private void createIconSelector(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Image");
        GridData gd = new GridData(4, 4, false, false);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        this.iconLabel = new Label((Composite)group, 0x1000000);
        this.iconLabel.setImage(this.icon);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 16;
        gd.heightHint = 16;
        this.iconLabel.setLayoutData((Object)gd);
        Button link = new Button((Composite)group, 8);
        link.setImage(SharedIcons.IMG_FIND);
        link.setToolTipText("Select");
        link.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        link = new Button((Composite)group, 8);
        link.setImage(SharedIcons.IMG_CLEAR);
        link.setToolTipText("Clear");
        link.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void selectIcon() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        WidgetHelper.setFileDialogFilterExtensions((FileDialog)dlg, (String[])new String[]{"*.gif;*.jpg;*.png", "*.*"});
        WidgetHelper.setFileDialogFilterNames((FileDialog)dlg, (String[])new String[]{"Image files", "All files"});
        String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        try {
            Image image = new Image((Device)this.getShell().getDisplay(), (InputStream)new FileInputStream(new File(fileName)));
            if (image.getImageData().width <= 16 && image.getImageData().height <= 16) {
                if (this.icon != null) {
                    this.icon.dispose();
                }
                this.icon = image;
                this.iconLabel.setImage(this.icon);
            } else {
                image.dispose();
                MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)"Image is too large");
            }
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)String.format("Can not load image %s", e.getLocalizedMessage()));
        }
    }

    protected void okPressed() {
        if (this.item == null) {
            this.item = new AppMenuItem(this.isSubMenu);
        }
        this.item.setName(this.textName.getText().trim());
        this.item.setDescription(this.textDescription.getText().trim());
        if (this.icon != null && this.icon.getImageData() != null) {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{this.icon.getImageData()};
            ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
            loader.save((OutputStream)stream, 5);
            this.item.setIcon(stream.toByteArray());
        }
        if (!this.isSubMenu) {
            this.item.setCommand(this.textCommand.getText().trim());
        }
        super.okPressed();
    }

    public AppMenuItem getItem() {
        return this.item;
    }
}

