/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;

public class FilePermissionDialog
extends Dialog {
    private int permissions;
    private String owner;
    private String group;
    private LabeledText textOwner;
    private LabeledText textGroup;
    private Button[] bitSelectors;

    public FilePermissionDialog(Shell parentShell, int permissions, String owner, String group) {
        super(parentShell);
        this.permissions = permissions;
        this.owner = owner;
        this.group = group;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Permissions");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(3, true);
        dialogArea.setLayout((Layout)gridLayout);
        this.textOwner = new LabeledText(dialogArea, 0);
        this.textOwner.setLabel("Owner");
        this.textOwner.setText(this.owner);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        gd.widthHint = 400;
        this.textOwner.setLayoutData((Object)gd);
        this.textGroup = new LabeledText(dialogArea, 0);
        this.textGroup.setLabel("Group");
        this.textGroup.setText(this.group);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        gd.widthHint = 400;
        this.textGroup.setLayoutData((Object)gd);
        this.bitSelectors = new Button[9];
        Group groupUser = new Group(dialogArea, 0);
        groupUser.setText("User");
        groupUser.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        groupUser.setLayoutData((Object)gd);
        this.addBitSelector((Composite)groupUser, "Read", 0);
        this.addBitSelector((Composite)groupUser, "Write", 1);
        this.addBitSelector((Composite)groupUser, "Execute", 2);
        Group groupGroup = new Group(dialogArea, 0);
        groupGroup.setText("Group");
        groupGroup.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        groupGroup.setLayoutData((Object)gd);
        this.addBitSelector((Composite)groupGroup, "Read", 3);
        this.addBitSelector((Composite)groupGroup, "Write", 4);
        this.addBitSelector((Composite)groupGroup, "Execute", 5);
        Group groupOther = new Group(dialogArea, 0);
        groupOther.setText("Other");
        groupOther.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        groupOther.setLayoutData((Object)gd);
        this.addBitSelector((Composite)groupOther, "Read", 6);
        this.addBitSelector((Composite)groupOther, "Write", 7);
        this.addBitSelector((Composite)groupOther, "Execute", 8);
        return dialogArea;
    }

    private void addBitSelector(Composite parent, String text, int bit) {
        this.bitSelectors[bit] = new Button(parent, 32);
        this.bitSelectors[bit].setText(text);
        this.bitSelectors[bit].setSelection((this.permissions & 1 << bit) != 0);
    }

    protected void okPressed() {
        this.owner = this.textOwner.getText().trim();
        this.group = this.textGroup.getText().trim();
        this.permissions = 0;
        for (int i = 0; i < this.bitSelectors.length; ++i) {
            if (!this.bitSelectors[i].getSelection()) continue;
            this.permissions |= 1 << i;
        }
        super.okPressed();
    }

    public int getPermissions() {
        return this.permissions;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }
}

