/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import java.util.Map;
import java.util.Set;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.ObjectIdMatchingData;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="element", strict=false)
public class EventMonitorConfig
extends DashboardElementConfig {
    @Element(required=true)
    private long objectId = 0L;
    @Element(required=false)
    private String filter = "";
    @Element(required=false)
    private int maxEvents = 100;
    @Element(required=false)
    private int timeRangeMinutes = 60;
    @Element(required=false)
    private String eventCodes = "";

    public Set<Long> getObjects() {
        Set objects = super.getObjects();
        objects.add(this.objectId);
        return objects;
    }

    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public int getMaxEvents() {
        return this.maxEvents;
    }

    public void setMaxEvents(int maxEvents) {
        this.maxEvents = maxEvents;
    }

    public int getTimeRangeMinutes() {
        return this.timeRangeMinutes;
    }

    public void setTimeRangeMinutes(int timeRangeMinutes) {
        this.timeRangeMinutes = timeRangeMinutes;
    }

    public int[] getEventCodes() {
        if (this.eventCodes == null || this.eventCodes.isEmpty()) {
            return new int[0];
        }
        String[] parts = this.eventCodes.split(",");
        int[] codes = new int[parts.length];
        int count = 0;
        for (String part : parts) {
            try {
                codes[count++] = Integer.parseInt(part.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (count < codes.length) {
            int[] result = new int[count];
            System.arraycopy(codes, 0, result, 0, count);
            return result;
        }
        return codes;
    }

    public void setEventCodes(int[] codes) {
        if (codes == null || codes.length == 0) {
            this.eventCodes = "";
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < codes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(codes[i]);
        }
        this.eventCodes = sb.toString();
    }
}

