/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Asset;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetListComparator;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetPropertyReader;
import org.netxms.nxmc.tools.ComparatorHelper;

public class AssetListComparator
extends ViewerComparator {
    private NXCSession session = Registry.getSession();
    private AssetPropertyReader propertyReader;

    public AssetListComparator(AssetPropertyReader propertyReader) {
        this.propertyReader = propertyReader;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        String attribute = (String)((SortableTableViewer)viewer).getTable().getSortColumn().getData("Attribute");
        if (attribute == null) {
            result = ((AbstractObject)e1).getObjectName().compareToIgnoreCase(((AbstractObject)e2).getObjectName());
        } else {
            Asset a1 = this.getAsset(e1);
            Asset a2 = this.getAsset(e2);
            String v1 = (String)a1.getProperties().get(attribute);
            String v2 = (String)a2.getProperties().get(attribute);
            switch (1.$SwitchMap$org$netxms$client$constants$AMDataType[((AssetAttribute)this.session.getAssetManagementSchema().get(attribute)).getDataType().ordinal()]) {
                case 1: {
                    Long i1 = null;
                    Long i2 = null;
                    try {
                        i1 = Long.parseLong(v1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        i2 = Long.parseLong(v2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (i1 == null) {
                        result = i2 == null ? 0 : -1;
                        break;
                    }
                    if (i2 == null) {
                        result = 1;
                        break;
                    }
                    result = Long.compare(i1, i2);
                    break;
                }
                case 2: {
                    Double n1 = null;
                    Double n2 = null;
                    try {
                        n1 = Double.parseDouble(v1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        n2 = Double.parseDouble(v2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n1 == null) {
                        result = n2 == null ? 0 : -1;
                        break;
                    }
                    if (n2 == null) {
                        result = 1;
                        break;
                    }
                    result = Double.compare(n1, n2);
                    break;
                }
                case 3: {
                    if (v1 == null) {
                        result = v2 == null ? 0 : -1;
                        break;
                    }
                    if (v2 == null) {
                        result = 1;
                        break;
                    }
                    result = ComparatorHelper.compareStringsNatural((String)v1, (String)v2);
                    break;
                }
                default: {
                    result = this.propertyReader.valueToText(attribute, v1).compareToIgnoreCase(this.propertyReader.valueToText(attribute, v2));
                }
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private Asset getAsset(Object element) {
        if (element instanceof Asset) {
            return (Asset)element;
        }
        return (Asset)this.session.findObjectById(((AbstractObject)element).getAssetId(), Asset.class);
    }
}

