/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.widgets;

import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.netxms.client.AgentList;
import org.netxms.client.AgentParameter;
import org.netxms.client.AgentTable;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.AgentDataTreeNode;
import org.netxms.nxmc.modules.agentmanagement.widgets.AgentDataTree;

public class AgentDataTree
extends Composite {
    private TreeViewer treeViewer;
    private AgentDataTreeNode[] rootNodes;

    public AgentDataTree(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer((Composite)this, 0);
        this.treeViewer.setContentProvider((IContentProvider)new AgentDataTreeContentProvider(this));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AgentDataTreeLabelProvider(this));
        this.treeViewer.setComparator((ViewerComparator)new AgentDataTreeComparator(this));
    }

    public void setInput(List<AgentParameter> parameters, List<AgentList> lists, List<AgentTable> tables) {
        if (parameters == null && lists == null && tables == null) {
            this.rootNodes = null;
            this.treeViewer.setInput(null);
            return;
        }
        this.rootNodes = AgentDataTreeNode.buildTree(parameters, lists, tables);
        this.treeViewer.setInput((Object)this.rootNodes);
        this.treeViewer.expandToLevel(2);
    }

    public AgentDataTreeNode getSelection() {
        ITreeSelection selection = this.treeViewer.getStructuredSelection();
        return (AgentDataTreeNode)selection.getFirstElement();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public Tree getTreeControl() {
        return this.treeViewer.getTree();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void selectByName(String name) {
        if (this.rootNodes == null) {
            return;
        }
        for (AgentDataTreeNode root : this.rootNodes) {
            AgentDataTreeNode node = this.findNodeByName(root, name);
            if (node == null) continue;
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
            return;
        }
    }

    private AgentDataTreeNode findNodeByName(AgentDataTreeNode node, String name) {
        if (name.equals(node.getFullName())) {
            return node;
        }
        for (AgentDataTreeNode child : node.getChildren()) {
            AgentDataTreeNode found = this.findNodeByName(child, name);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

