/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.packages.PackageDeploymentJob;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.ViewerElementUpdater;
import org.xnap.commons.i18n.I18n;

public class DeploymentJobLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private final I18n i18n = LocalizationHelper.getI18n(DeploymentJobLabelProvider.class);
    private final String[] states = new String[]{this.i18n.tr("Scheduled"), this.i18n.tr("Pending"), this.i18n.tr("Initializing"), this.i18n.tr("Transferring file"), this.i18n.tr("Installing"), this.i18n.tr("Waiting for agent"), this.i18n.tr("Completed"), this.i18n.tr("Failed"), this.i18n.tr("Cancelled")};
    private NXCSession session = Registry.getSession();
    private TableViewer viewer;

    public DeploymentJobLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        PackageDeploymentJob job = (PackageDeploymentJob)element;
        switch (columnIndex) {
            case 7: {
                if (job.getCompletionTime() == null || job.getCompletionTime().getTime() == 0L) {
                    return "";
                }
                return DateFormatFactory.getDateTimeFormat().format(job.getCompletionTime());
            }
            case 5: {
                if (job.getCreationTime() == null || job.getCreationTime().getTime() == 0L) {
                    return "";
                }
                return DateFormatFactory.getDateTimeFormat().format(job.getCreationTime());
            }
            case 14: {
                return job.getDescription();
            }
            case 4: {
                return job.getErrorMessage();
            }
            case 6: {
                if (job.getExecutionTime() == null || job.getExecutionTime().getTime() == 0L) {
                    return "";
                }
                return DateFormatFactory.getDateTimeFormat().format(job.getExecutionTime());
            }
            case 13: {
                return job.getPackageFile();
            }
            case 0: {
                return Long.toString(job.getId());
            }
            case 1: {
                return this.session.getObjectName(job.getNodeId());
            }
            case 8: {
                return Long.toString(job.getPackageId());
            }
            case 10: {
                return job.getPackageName();
            }
            case 9: {
                return job.getPackageType();
            }
            case 11: {
                return job.getPlatform();
            }
            case 3: {
                try {
                    return this.states[job.getStatus().getValue()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return this.i18n.tr("Unknown");
                }
            }
            case 2: {
                AbstractUserObject user = this.session.findUserDBObjectById(job.getUserId(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
                return user != null ? user.getName() : "[" + Long.toString(job.getUserId()) + "]";
            }
            case 12: {
                return job.getVersion();
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public void dispose() {
        this.viewer = null;
        super.dispose();
    }
}

