/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets.ansi;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.netxms.nxmc.base.widgets.ansi.AnsiConsoleColorPalette;
import org.netxms.nxmc.base.widgets.helpers.StyleRange;
import org.netxms.nxmc.tools.ColorCache;

public class AnsiConsoleAttributes
implements Cloneable {
    public static final int UNDERLINE_NONE = -1;
    public Integer currentBgColor;
    public Integer currentFgColor;
    public int underline;
    public boolean bold;
    public boolean italic;
    public boolean invert;
    public boolean conceal;
    public boolean strike;
    public boolean framed;
    private ColorCache colorCache;
    private Control control;

    public AnsiConsoleAttributes(Control control) {
        this.control = control;
        this.colorCache = new ColorCache(control);
        this.reset();
    }

    public void reset() {
        this.currentBgColor = null;
        this.currentFgColor = null;
        this.underline = -1;
        this.bold = false;
        this.italic = false;
        this.invert = false;
        this.conceal = false;
        this.strike = false;
        this.framed = false;
    }

    public AnsiConsoleAttributes clone() {
        AnsiConsoleAttributes result = new AnsiConsoleAttributes(this.control);
        result.currentBgColor = this.currentBgColor;
        result.currentFgColor = this.currentFgColor;
        result.underline = this.underline;
        result.bold = this.bold;
        result.italic = this.italic;
        result.invert = this.invert;
        result.conceal = this.conceal;
        result.strike = this.strike;
        result.framed = this.framed;
        return result;
    }

    public void updateRangeStyle(StyleRange range) {
        if (this.currentFgColor != null) {
            range.foreground = this.colorCache.create(AnsiConsoleColorPalette.getColor((Integer)this.currentFgColor));
        }
        if (this.currentBgColor != null) {
            range.background = this.colorCache.create(AnsiConsoleColorPalette.getColor((Integer)this.currentBgColor));
        }
        if (this.invert) {
            if (range.foreground == null) {
                range.foreground = this.colorCache.create(this.control.getForeground().getRGB());
            }
            if (range.background == null) {
                range.background = this.colorCache.create(this.control.getBackground().getRGB());
            }
            Color tmp = range.background;
            range.background = range.foreground;
            range.foreground = tmp;
        }
        if (this.conceal) {
            if (range.background == null) {
                range.background = this.colorCache.create(this.control.getBackground().getRGB());
            }
            range.foreground = range.background;
        }
        range.fontStyle = 0;
        if (this.bold) {
            range.fontStyle |= 1;
        }
        if (this.italic) {
            range.fontStyle |= 2;
        }
        if (this.underline != -1) {
            range.underline = true;
            range.underlineColor = range.foreground;
            range.underlineStyle = this.underline;
        } else {
            range.underline = false;
        }
        range.strikeout = this.strike;
        range.strikeoutColor = range.foreground;
    }
}

