/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.editors;

import java.util.LinkedList;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.dialogs.CustomTimePeriodDialog;
import org.netxms.nxmc.base.editors.ListActions;
import org.netxms.nxmc.base.widgets.helpers.TimePeriodFunctions;

public class TimePeriodEditor
extends FieldEditor {
    private List list;
    private Composite buttonBox;
    private Button addButton;
    private Button removeButton;
    private SelectionListener selectionListener;
    String listName;
    String entryPrefix;
    LinkedList<ListActions> actions = new LinkedList();

    protected TimePeriodEditor() {
    }

    public TimePeriodEditor(String name, String labelText, Composite parent, String listName, String entryPrefix) {
        this.init(name, labelText);
        this.createControl(parent);
        this.listName = listName;
        this.entryPrefix = entryPrefix;
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        String input = null;
        int time = 0;
        CustomTimePeriodDialog dlg = new CustomTimePeriodDialog(this.getShell());
        if (dlg.open() == 0 && (time = dlg.getTime()) > 0) {
            input = TimePeriodFunctions.timeToString((int)time);
        }
        if (input != null) {
            int index = this.list.getItemCount();
            this.list.add(input, index);
            ListActions act = new ListActions();
            act.action = 0;
            act.element = index;
            act.value = time;
            this.actions.add(act);
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, "ListEditor.add");
        this.removeButton = this.createPushButton(box, "ListEditor.remove");
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.list = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String[] array = TimePeriodFunctions.getValues((String)this.listName, (String)this.entryPrefix);
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    this.list.add(array[i]);
                }
            }
        }
    }

    protected void doLoad() {
        if (this.list != null) {
            this.list.removeAll();
            String[] array = TimePeriodFunctions.getValues((String)this.listName, (String)this.entryPrefix);
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    this.list.add(array[i]);
                }
            }
        }
    }

    protected void doStore() {
        int menuSize;
        PreferenceStore settings = (PreferenceStore)this.getPreferenceStore();
        try {
            menuSize = settings.getInt(this.listName);
        }
        catch (NumberFormatException e) {
            menuSize = 0;
        }
        ListActions act = new ListActions();
        while (!this.actions.isEmpty()) {
            act = (ListActions)this.actions.removeFirst();
            switch (act.action) {
                case 0: {
                    settings.set(this.entryPrefix + act.element, act.value);
                    settings.set(this.listName, ++menuSize);
                    break;
                }
                case 1: {
                    settings.set(this.listName, --menuSize);
                    for (int i = act.element; i < menuSize; ++i) {
                        settings.set(this.entryPrefix + i, settings.getInt(this.entryPrefix + (i + 1)));
                    }
                    break;
                }
            }
        }
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new List(parent, 2820);
            this.list.setFont(parent.getFont());
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        ListActions act = new ListActions();
        act.action = 1;
        act.element = index;
        this.actions.add(act);
        if (index >= 0) {
            this.list.remove(index);
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
        int index = this.list.getSelectionIndex();
        this.removeButton.setEnabled(index >= 0);
    }

    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getListControl(parent).setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected List getList() {
        return this.list;
    }
}

