/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.services;

import org.netxms.client.NXCSession;
import org.netxms.client.constants.ColumnFilterSetOperation;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.LogFilter;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.Collector;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.modules.logviewer.views.LogViewer;
import org.netxms.nxmc.modules.logviewer.views.ObjectLogViewer;

public class LogDescriptor {
    protected String logName;
    protected String viewTitle;
    protected String menuItemText;
    protected String filterColumn;

    public LogDescriptor(String logName, String viewTitle, String menuItemText, String filterColumn) {
        this.logName = logName;
        this.viewTitle = viewTitle;
        this.menuItemText = menuItemText != null ? menuItemText : viewTitle;
        this.filterColumn = filterColumn;
    }

    public boolean isValidForSession(NXCSession session) {
        return true;
    }

    public LogFilter createFilter(AbstractObject object) {
        if (this.filterColumn == null) {
            return null;
        }
        ColumnFilter cf = new ColumnFilter();
        cf.setOperation(ColumnFilterSetOperation.OR);
        if (object instanceof DataCollectionTarget || object instanceof BusinessService) {
            cf.addSubFilter(new ColumnFilter(ColumnFilterType.EQUALS, object.getObjectId()));
        } else {
            cf.addSubFilter(new ColumnFilter(ColumnFilterType.CHILDOF, object.getObjectId()));
        }
        if (object instanceof Collector) {
            cf.addSubFilter(new ColumnFilter(ColumnFilterType.CHILDOF, object.getObjectId()));
        }
        LogFilter filter = new LogFilter();
        filter.setColumnFilter(this.filterColumn, cf);
        return filter;
    }

    public LogViewer createView() {
        return new LogViewer(this.viewTitle, this.logName, "");
    }

    public ObjectLogViewer createContextView(AbstractObject object, long contextId) {
        return new ObjectLogViewer(this, object, contextId);
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return this.filterColumn != null && (object instanceof DataCollectionTarget || ObjectTool.isContainerObject((AbstractObject)object));
    }

    public String getLogName() {
        return this.logName;
    }

    public String getViewTitle() {
        return this.viewTitle;
    }

    public String getMenuItemText() {
        return this.menuItemText;
    }
}

