/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.views.helpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class UserLabelDecorator
implements ILabelDecorator {
    private Map<Image, Image[]> imageCache = new HashMap();

    public Image decorateImage(Image image, Object element) {
        if (image == null || !(element instanceof AbstractUserObject)) {
            return null;
        }
        int state = 0;
        if (((AbstractUserObject)element).isDisabled()) {
            state |= 1;
        }
        if ((((AbstractUserObject)element).getFlags() & 0x100) != 0) {
            state |= 2;
        }
        if (state == 0) {
            return null;
        }
        int index = state - 1;
        Image[] decoratedImages = (Image[])this.imageCache.get(image);
        if (decoratedImages != null) {
            if (decoratedImages[index] != null) {
                return decoratedImages[index];
            }
        } else {
            decoratedImages = new Image[3];
            this.imageCache.put(image, decoratedImages);
        }
        ImageDescriptor[] overlays = new ImageDescriptor[6];
        if ((state & 1) != 0) {
            overlays[3] = StatusDisplayInfo.getStatusOverlayImageDescriptor((ObjectStatus)ObjectStatus.DISABLED);
        }
        if ((state & 2) != 0) {
            overlays[0] = StatusDisplayInfo.getStatusOverlayImageDescriptor((ObjectStatus)ObjectStatus.MINOR);
        }
        DecorationOverlayIcon icon = new DecorationOverlayIcon(image, overlays);
        decoratedImages[index] = icon.createImage();
        return decoratedImages[index];
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public void dispose() {
        Iterator iterator = this.imageCache.values().iterator();
        while (iterator.hasNext()) {
            Image[] images;
            for (Image image : images = (Image[])iterator.next()) {
                if (image == null) continue;
                image.dispose();
            }
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

