/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.reporting.propertypages;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.reporting.ReportRenderFormat;
import org.netxms.client.reporting.ReportingJob;
import org.netxms.nxmc.base.propertypages.PropertyPage;

public class Notifications
extends PropertyPage {
    public static final String ID = "org.netxms.ui.eclipse.reporter.propertypages.Notification";
    private ReportingJob job;
    private Composite emailGroup;
    private ListViewer listViewer;
    private Button sendReport;
    private Button sendNotify;
    private Button pdfFormat;
    private Button xlsxFormat;

    public Notifications(ReportingJob job) {
        super("Notifications");
        this.job = job;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogArea.setLayout((Layout)dialogLayout);
        this.sendNotify = new Button(dialogArea, 32);
        this.sendNotify.setLayoutData((Object)new GridData(16384, 128, true, false, 2, 1));
        this.sendNotify.setText("Send notification on job completion");
        this.sendNotify.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.emailGroup = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.emailGroup.setLayout((Layout)layout);
        this.emailGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblMail = new Label(this.emailGroup, 0);
        lblMail.setLayoutData((Object)new GridData(16384, 128, true, false, 2, 1));
        lblMail.setText("Recipients");
        this.listViewer = new ListViewer(this.emailGroup, 2562);
        this.listViewer.getList().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        Button buttonAdd = new Button(this.emailGroup, 8);
        GridData gd = new GridData(4, 128, false, false);
        gd.widthHint = 90;
        buttonAdd.setLayoutData((Object)gd);
        buttonAdd.setText("Add...");
        buttonAdd.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button buttonRemove = new Button(this.emailGroup, 8);
        gd = new GridData(4, 128, false, false);
        gd.widthHint = 90;
        buttonRemove.setLayoutData((Object)gd);
        buttonRemove.setText("Remove");
        buttonRemove.setEnabled(false);
        buttonRemove.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite attachmentGroup = new Composite(this.emailGroup, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        attachmentGroup.setLayout((Layout)layout);
        attachmentGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        this.sendReport = new Button(attachmentGroup, 32);
        this.sendReport.setLayoutData((Object)new GridData(16384, 4, true, false, 2, 1));
        this.sendReport.setText("Attach rendered report to notification email as");
        this.sendReport.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.pdfFormat = new Button(attachmentGroup, 16);
        this.pdfFormat.setEnabled(this.sendReport.getSelection());
        this.pdfFormat.setText("PDF");
        this.pdfFormat.setSelection(true);
        this.xlsxFormat = new Button(attachmentGroup, 16);
        this.xlsxFormat.setEnabled(this.sendReport.getSelection());
        this.xlsxFormat.setText("XLSX");
        this.recursiveSetEnabled((Control)this.emailGroup, false);
        return dialogArea;
    }

    private void addMail() {
        InputDialog dlg = new InputDialog(this.emailGroup.getShell(), "Add mail", "Enter mail", "", (IInputValidator)new /* Unavailable Anonymous Inner Class!! */);
        if (dlg.open() == 0) {
            this.job.getEmailRecipients().add(dlg.getValue());
            this.listViewer.setInput((Object)this.job.getEmailRecipients().toArray());
        }
    }

    private void removeMail() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        for (Object o : selection.toList()) {
            this.job.getEmailRecipients().remove((String)o);
        }
        this.listViewer.setInput((Object)this.job.getEmailRecipients().toArray());
    }

    public void recursiveSetEnabled(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Composite comp = (Composite)control;
            for (Control c : comp.getChildren()) {
                this.recursiveSetEnabled(c, enabled);
            }
        }
        control.setEnabled(enabled);
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.sendReport.getSelection()) {
            this.job.setRenderFormat(this.pdfFormat.getSelection() ? ReportRenderFormat.PDF : ReportRenderFormat.XLSX);
        } else {
            this.job.setRenderFormat(ReportRenderFormat.NONE);
        }
        return true;
    }
}

