/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.InputField;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.client.constants.InputFieldType;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.base.widgets.TextConsole;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objects.dialogs.InputFieldEntryDialog;
import org.netxms.nxmc.modules.objecttools.views.ObjectToolResultView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public abstract class AbstractCommandResultView
extends ObjectToolResultView {
    private I18n i18n = LocalizationHelper.getI18n(AbstractCommandResultView.class);
    protected Map<String, String> inputValues;
    protected List<String> maskedFields;
    protected TextConsole console;
    protected long streamId = 0L;
    protected boolean askInputValues = false;
    protected boolean viewRestored = false;
    private TextConsole.IOConsoleOutputStream out;
    private TextOutputListener outputListener;
    private Action actionClear;
    private Action actionScrollLock;
    private Action actionCopy;
    private Action actionSelectAll;
    protected Action actionRestart;

    public AbstractCommandResultView(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields) {
        super(node, tool, ResourceManager.getImageDescriptor((String)"icons/object-tools/terminal.png"), false);
        this.inputValues = inputValues;
        this.maskedFields = maskedFields;
        this.outputListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected AbstractCommandResultView() {
    }

    public View cloneView() {
        AbstractCommandResultView view = (AbstractCommandResultView)super.cloneView();
        view.inputValues = this.inputValues;
        view.maskedFields = this.maskedFields;
        view.outputListener = new /* Unavailable Anonymous Inner Class!! */;
        return view;
    }

    protected void postClone(View view) {
        super.postClone(view);
        AbstractCommandResultView origin = (AbstractCommandResultView)view;
        this.console.setText(origin.console.getText());
        this.actionRestart.setEnabled(true);
    }

    protected void createContent(Composite parent) {
        this.console = new TextConsole(parent, 0);
        this.console.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        if (!this.viewRestored) {
            this.execute();
        } else {
            this.actionRestart.setEnabled(true);
        }
    }

    protected void createActions() {
        this.actionClear = new /* Unavailable Anonymous Inner Class!! */;
        this.actionScrollLock = new /* Unavailable Anonymous Inner Class!! */;
        this.actionScrollLock.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/scroll-lock.png"));
        this.actionScrollLock.setChecked(false);
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy.setEnabled(false);
        this.actionSelectAll = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRestart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRestart.setEnabled(false);
    }

    private void reExecute() {
        if ((this.tool.getFlags() & 1) != 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            this.execute();
        }
    }

    protected abstract void execute();

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu((Control)this.console);
        this.console.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    public void setFocus() {
        this.console.setFocus();
    }

    public void dispose() {
        this.closeOutputStream();
        super.dispose();
    }

    protected TextOutputListener getOutputListener() {
        return this.outputListener;
    }

    protected void createOutputStream() {
        this.closeOutputStream();
        this.out = this.console.newOutputStream();
    }

    protected void closeOutputStream() {
        if (this.out == null) {
            return;
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out = null;
    }

    protected void writeToOutputStream(String text) {
        if (this.out == null) {
            return;
        }
        try {
            this.out.write(text);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean restoreUserInputFields() {
        if (!this.askInputValues) {
            return true;
        }
        InputField[] fields = this.tool.getInputFields();
        if (fields.length > 0) {
            Arrays.sort(fields, new /* Unavailable Anonymous Inner Class!! */);
            InputFieldEntryDialog dlg = new InputFieldEntryDialog(this.getWindow().getShell(), this.tool.getDisplayName(), fields, this.inputValues);
            if (dlg.open() != 0) {
                return false;
            }
            this.inputValues = dlg.getValues();
            this.maskedFields.clear();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getType() != InputFieldType.PASSWORD) continue;
                this.maskedFields.add(fields[i].getName());
            }
        }
        this.askInputValues = false;
        return true;
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("inputValues.keys", this.inputValues.keySet());
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry v : this.inputValues.entrySet()) {
            if (this.maskedFields.contains(v.getKey())) {
                values.add("");
                continue;
            }
            values.add((String)v.getValue());
        }
        memento.set("inputValues.values", values);
        if (this.maskedFields != null) {
            memento.set("maskedFields", (Collection)this.maskedFields);
        }
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        List keys = memento.getAsStringList("inputValues.keys");
        List values = memento.getAsStringList("inputValues.values");
        this.inputValues = new HashMap();
        for (int i = 0; i < keys.size() && i < values.size(); ++i) {
            this.inputValues.put((String)keys.get(i), (String)values.get(i));
        }
        this.maskedFields = memento.getAsStringList("maskedFields");
        this.askInputValues = this.maskedFields.size() > 0;
        this.viewRestored = true;
        this.outputListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ NXCSession access$000(AbstractCommandResultView x0) {
        return x0.session;
    }
}

