/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.FdbEntry;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.localization.LocalizationHelper;

public class FDBFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private static final String TYPE_MATCH_DYNAMIC = LocalizationHelper.getI18n(FDBFilter.class).tr("Dynamic").toLowerCase();
    private static final String TYPE_MATCH_STATIC = LocalizationHelper.getI18n(FDBFilter.class).tr("Static").toLowerCase();
    private static final String TYPE_MATCH_UNKNOWN = LocalizationHelper.getI18n(FDBFilter.class).tr("Unknown").toLowerCase();
    private NXCSession session = Registry.getSession();
    private String filterString = null;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        FdbEntry e = (FdbEntry)element;
        if (e.getAddress().toString().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (Integer.toString(e.getPort()).contains(this.filterString)) {
            return true;
        }
        if (e.getInterfaceName().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (Integer.toString(e.getVlanId()).contains(this.filterString)) {
            return true;
        }
        if (e.getNodeId() != 0L && this.session.getObjectName(e.getNodeId()).toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (this.matchType(e)) {
            return true;
        }
        String vendor = this.session.getVendorByMac(e.getAddress(), null);
        return vendor != null && vendor.toLowerCase().contains(this.filterString);
    }

    private boolean matchType(FdbEntry en) {
        switch (en.getType()) {
            case 3: {
                return TYPE_MATCH_DYNAMIC.contains(this.filterString);
            }
            case 5: {
                return TYPE_MATCH_STATIC.contains(this.filterString);
            }
        }
        return TYPE_MATCH_UNKNOWN.contains(this.filterString);
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }
}

