/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.AccessControl;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.helpers.AccessListComparator;
import org.netxms.nxmc.modules.objects.propertypages.helpers.AccessListLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class AccessControl
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(AccessControl.class);
    private SortableTableViewer userList;
    private HashMap<Integer, Button> accessChecks = new HashMap(11);
    private HashMap<Integer, AccessListElement> acl;
    private Button checkInherit;
    private NXCSession session;

    public AccessControl(AbstractObject object) {
        super(LocalizationHelper.getI18n(AccessControl.class).tr("Access Control"), object);
    }

    public String getId() {
        return "accessControl";
    }

    public int getPriority() {
        return 11;
    }

    protected Control createContents(Composite parent) {
        this.session = Registry.getSession();
        AccessListElement[] origAcl = this.object.getAccessList();
        this.acl = new HashMap(origAcl.length);
        for (int i = 0; i < origAcl.length; ++i) {
            this.acl.put(origAcl[i].getUserId(), new AccessListElement(origAcl[i]));
        }
        this.collectInheritedAccessRights(this.object);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group users = new Group(dialogArea, 0);
        users.setText(this.i18n.tr("Users and Groups"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        users.setLayoutData((Object)gd);
        layout = new GridLayout();
        users.setLayout((Layout)layout);
        String[] columnNames = new String[]{this.i18n.tr("Login name"), this.i18n.tr("Rights")};
        int[] columnWidths = new int[]{220, 180};
        this.userList = new SortableTableViewer((Composite)users, columnNames, columnWidths, 0, 128, 67586);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userList.setLabelProvider((IBaseLabelProvider)new AccessListLabelProvider());
        this.userList.setComparator((ViewerComparator)new AccessListComparator());
        this.userList.setInput((Object)this.acl.values().toArray());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.userList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)users, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        addButton.setText(this.i18n.tr("&Add..."));
        addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button deleteButton = new Button(buttons, 8);
        deleteButton.setText(this.i18n.tr("&Delete"));
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Group rights = new Group(dialogArea, 0);
        rights.setText(this.i18n.tr("Access Rights"));
        rights.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        rights.setLayoutData((Object)gd);
        this.createAccessCheck((Composite)rights, this.i18n.tr("Read"), Integer.valueOf(1));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Read agent data"), Integer.valueOf(65536));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Read SNMP data"), Integer.valueOf(131072));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Modify"), Integer.valueOf(2));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Edit comments"), Integer.valueOf(0x200000));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Manage responsible users"), Integer.valueOf(0x400000));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Create child objects"), Integer.valueOf(4));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Delegated read"), Integer.valueOf(0x800000));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Delete"), Integer.valueOf(8));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Control"), Integer.valueOf(256));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Send events"), Integer.valueOf(128));
        this.createAccessCheck((Composite)rights, this.i18n.tr("View alarms"), Integer.valueOf(16));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Update alarms"), Integer.valueOf(64));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Terminate alarms"), Integer.valueOf(512));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Create helpdesk tickets"), Integer.valueOf(2048));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Push data"), Integer.valueOf(1024));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Access control"), Integer.valueOf(32));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Download files"), Integer.valueOf(4096));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Upload files"), Integer.valueOf(8192));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Manage files"), Integer.valueOf(16384));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Configure agent"), Integer.valueOf(0x100000));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Take screenshot"), Integer.valueOf(262144));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Control maintenance mode"), Integer.valueOf(32768));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Edit maintenance journal"), Integer.valueOf(524288));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Manage policies"), Integer.valueOf(0x1000000));
        this.createAccessCheck((Composite)rights, this.i18n.tr("Manage incidents"), Integer.valueOf(0x2000000));
        this.userList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkInherit = new Button(dialogArea, 32);
        this.checkInherit.setText(this.i18n.tr("&Inherit access rights from parent object(s)"));
        if (this.object.getParentCount() > 0) {
            this.checkInherit.setSelection(this.object.isInheritAccessRights());
        } else {
            this.checkInherit.setSelection(false);
            this.checkInherit.setEnabled(false);
        }
        this.checkInherit.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.syncUsersAndRefresh();
        return dialogArea;
    }

    private void collectInheritedAccessRights(AbstractObject currentObject) {
        if (!currentObject.isInheritAccessRights()) {
            return;
        }
        for (AbstractObject o : currentObject.getParentsAsArray()) {
            for (AccessListElement e : o.getAccessList()) {
                if (this.acl.containsKey(e.getUserId())) continue;
                this.acl.put(e.getUserId(), new AccessListElement(e, true));
            }
            this.collectInheritedAccessRights(o);
        }
    }

    private void syncUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        5 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void createAccessCheck(Composite parent, String name, Integer bitMask) {
        Button check = new Button(parent, 32);
        check.setText(name);
        check.setEnabled(false);
        check.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.accessChecks.put(bitMask, check);
    }

    private void enableAllChecks(boolean enabled) {
        for (Button b : this.accessChecks.values()) {
            b.setEnabled(enabled);
        }
    }

    protected boolean applyChanges(boolean isApply) {
        boolean inheritAccessRights = this.checkInherit.getSelection();
        List accessRights = this.acl.values().stream().filter(e -> !e.isInherited()).collect(Collectors.toList());
        if (!inheritAccessRights && accessRights.isEmpty() && !MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)this.i18n.tr("Access Control Warning"), (String)this.i18n.tr("There are no direct or inherited access control rules for this object. If you continue with this change, object will be accessible only by the user \"system\". Do you want to proceed?"))) {
            this.checkInherit.setSelection(true);
            this.collectInheritedAccessRights(this.object);
            this.userList.setInput((Object)this.acl.values().toArray());
            return false;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setACL(accessRights);
        md.setInheritAccessRights(inheritAccessRights);
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkInherit.setSelection(true);
        this.acl.clear();
        this.userList.setInput((Object)this.acl.values().toArray());
    }
}

