/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.views;

import java.util.ArrayList;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.LogFilter;
import org.netxms.client.log.OrderingColumn;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.views.LogViewer;
import org.xnap.commons.i18n.I18n;

public class AdHocEventLogView
extends LogViewer {
    private final I18n i18n = LocalizationHelper.getI18n(AdHocEventLogView.class);
    private Long sourceObjectId;
    private Integer eventCode;
    private String viewTitleSuffix;

    protected AdHocEventLogView() {
    }

    public AdHocEventLogView(Long sourceObjectId, Integer eventCode, String viewTitleSuffix) {
        super(LocalizationHelper.getI18n(AdHocEventLogView.class).tr("Events") + " - " + viewTitleSuffix, "EventLog", ".adhoc." + String.valueOf(sourceObjectId != null ? sourceObjectId : "0") + "." + String.valueOf(eventCode != null ? eventCode : "0") + "." + System.currentTimeMillis());
        this.sourceObjectId = sourceObjectId;
        this.eventCode = eventCode;
        this.viewTitleSuffix = viewTitleSuffix;
    }

    public View cloneView() {
        AdHocEventLogView view = (AdHocEventLogView)super.cloneView();
        view.sourceObjectId = this.sourceObjectId;
        view.eventCode = this.eventCode;
        view.viewTitleSuffix = this.viewTitleSuffix;
        return view;
    }

    protected void postContentCreate() {
        LogFilter filter = this.createEventFilter();
        this.queryWithFilter(filter);
        super.postContentCreate();
    }

    private LogFilter createEventFilter() {
        LogFilter filter = new LogFilter();
        if (this.sourceObjectId != null) {
            ColumnFilter sourceFilter = new ColumnFilter(ColumnFilterType.EQUALS, this.sourceObjectId.longValue());
            filter.setColumnFilter("event_source", sourceFilter);
        }
        if (this.eventCode != null) {
            ColumnFilter codeFilter = new ColumnFilter(ColumnFilterType.EQUALS, (long)this.eventCode.intValue());
            filter.setColumnFilter("event_code", codeFilter);
        }
        ArrayList<OrderingColumn> orderingColumns = new ArrayList<OrderingColumn>(1);
        orderingColumns.add(new OrderingColumn("event_timestamp", this.i18n.tr("Time"), true));
        filter.setOrderingColumns(orderingColumns);
        return filter;
    }

    public boolean isCloseable() {
        return true;
    }

    public String getFullName() {
        return this.getName();
    }
}

