/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.incidents.views;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.IncidentState;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.Incident;
import org.netxms.client.events.IncidentComment;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.CopyTableRowsAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.incidents.dialogs.EditIncidentCommentDialog;
import org.netxms.nxmc.modules.incidents.views.IncidentDetails;
import org.netxms.nxmc.modules.incidents.widgets.IncidentCommentsEditor;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.modules.users.dialogs.UserSelectionDialog;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.FontTools;
import org.netxms.nxmc.tools.ImageCache;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class IncidentDetails
extends AdHocObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(IncidentDetails.class);
    public static final int AL_COLUMN_SEVERITY = 0;
    public static final int AL_COLUMN_STATE = 1;
    public static final int AL_COLUMN_SOURCE = 2;
    public static final int AL_COLUMN_MESSAGE = 3;
    public static final int AL_COLUMN_CREATED = 4;
    private long incidentId;
    private Incident incident;
    private NXCSession session = Registry.getSession();
    private String[] stateNames;
    private ImageCache imageCache;
    private BaseObjectLabelProvider objectLabelProvider = new BaseObjectLabelProvider();
    private Image[] stateImages;
    private Font titleFont;
    private Font boldFont;
    private Composite content;
    private ScrolledComposite leftScroller;
    private Composite leftColumn;
    private Composite rightColumn;
    private Text textTitle;
    private Composite buttonArea;
    private Button buttonEdit;
    private Button buttonSave;
    private Button buttonCancel;
    private CLabel labelState;
    private CLabel labelSource;
    private CLabel labelCreated;
    private CLabel labelAssigned;
    private CLabel labelLastChange;
    private CLabel labelResolved;
    private CLabel labelClosed;
    private Composite commentsArea;
    private Button buttonAddComment;
    private Map<Long, IncidentCommentsEditor> commentEditors = new HashMap();
    private SortableTableViewer alarmViewer;
    private Button buttonBlock;
    private Button buttonInProgress;
    private Button buttonResolve;
    private Button buttonReopen;
    private Button buttonClose;
    private Button buttonAssign;
    private Action actionAskAi;
    private Action actionAssign;
    private Action actionBlock;
    private Action actionInProgress;
    private Action actionResolve;
    private Action actionReopen;
    private Action actionClose;
    private CopyTableRowsAction copyAlarmAction;

    public IncidentDetails(long incidentId, long contextObject) {
        super(String.format(LocalizationHelper.getI18n(IncidentDetails.class).tr("Incident #%d"), incidentId), ResourceManager.getImageDescriptor((String)"icons/object-views/incidents.png"), "objects.incident-details", contextObject, contextObject, false);
        this.incidentId = incidentId;
    }

    protected IncidentDetails() {
        super(LocalizationHelper.getI18n(IncidentDetails.class).tr("Incident Details"), ResourceManager.getImageDescriptor((String)"icons/object-views/incidents.png"), "objects.incident-details", 0L, 0L, false);
    }

    public View cloneView() {
        IncidentDetails view = (IncidentDetails)super.cloneView();
        view.incidentId = this.incidentId;
        return view;
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        this.refresh();
    }

    protected void createContent(Composite parent) {
        this.stateNames = new String[5];
        this.stateNames[IncidentState.OPEN.getValue()] = this.i18n.tr("Open");
        this.stateNames[IncidentState.IN_PROGRESS.getValue()] = this.i18n.tr("In Progress");
        this.stateNames[IncidentState.BLOCKED.getValue()] = this.i18n.tr("Blocked");
        this.stateNames[IncidentState.RESOLVED.getValue()] = this.i18n.tr("Resolved");
        this.stateNames[IncidentState.CLOSED.getValue()] = this.i18n.tr("Closed");
        this.titleFont = FontTools.createTitleFont();
        this.boldFont = FontTools.createAdjustedFont((Font)JFaceResources.getDefaultFont(), (int)0, (int)1);
        parent.addDisposeListener((DisposeListener & Serializable)e -> {
            this.boldFont.dispose();
            this.titleFont.dispose();
        });
        this.imageCache = new ImageCache((Control)parent);
        this.content = parent;
        this.stateImages = new Image[5];
        this.stateImages[IncidentState.OPEN.getValue()] = this.imageCache.create(ResourceManager.getImageDescriptor((String)"icons/incidents/incident-open.png"));
        this.stateImages[IncidentState.IN_PROGRESS.getValue()] = this.imageCache.create(ResourceManager.getImageDescriptor((String)"icons/incidents/incident-in-progress.png"));
        this.stateImages[IncidentState.BLOCKED.getValue()] = this.imageCache.create(ResourceManager.getImageDescriptor((String)"icons/incidents/incident-blocked.png"));
        this.stateImages[IncidentState.RESOLVED.getValue()] = this.imageCache.create(ResourceManager.getImageDescriptor((String)"icons/incidents/incident-resolved.png"));
        this.stateImages[IncidentState.CLOSED.getValue()] = this.imageCache.create(ResourceManager.getImageDescriptor((String)"icons/incidents/incident-closed.png"));
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        parent.setBackground(this.getDisplay().getSystemColor(25));
        this.createHeaderSection(parent);
        this.createContentArea(parent);
        this.createActions();
        this.createContextMenu();
    }

    private void createHeaderSection(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        header.setLayout((Layout)layout);
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        header.setBackground(parent.getBackground());
        Label label = new Label(header, 0);
        label.setText("#" + this.incidentId);
        label.setFont(this.titleFont);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        label.setBackground(parent.getBackground());
        label.setForeground(WidgetHelper.getSystemColor((int)39));
        this.textTitle = new Text(header, 12);
        this.textTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textTitle.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.textTitle.setFont(this.titleFont);
        this.buttonArea = new Composite(header, 0);
        GridLayout buttonLayout = new GridLayout(2, true);
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        this.buttonArea.setLayout((Layout)buttonLayout);
        this.buttonArea.setBackground(header.getBackground());
        this.buttonEdit = new Button(this.buttonArea, 8);
        this.buttonEdit.setText(this.i18n.tr("Edit"));
        this.buttonEdit.addListener(13, (Listener & Serializable)e -> this.enterEditMode());
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 90;
        this.buttonEdit.setLayoutData((Object)gd);
        this.buttonSave = new Button(this.buttonArea, 8);
        this.buttonSave.setText(this.i18n.tr("Save"));
        this.buttonSave.setVisible(false);
        this.buttonSave.addListener(13, (Listener & Serializable)e -> this.saveDetails());
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 90;
        gd.exclude = true;
        this.buttonSave.setLayoutData((Object)gd);
        this.buttonCancel = new Button(this.buttonArea, 8);
        this.buttonCancel.setText(this.i18n.tr("Cancel"));
        this.buttonCancel.setVisible(false);
        this.buttonCancel.addListener(13, (Listener & Serializable)e -> this.cancelEditMode());
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 90;
        gd.exclude = true;
        this.buttonCancel.setLayoutData((Object)gd);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createContentArea(Composite parent) {
        Composite contentArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        contentArea.setLayout((Layout)layout);
        contentArea.setLayoutData((Object)new GridData(4, 4, true, true));
        contentArea.setBackground(parent.getBackground());
        this.leftScroller = new ScrolledComposite(contentArea, 512);
        this.leftScroller.setExpandHorizontal(true);
        this.leftScroller.setExpandVertical(true);
        GridData leftGd = new GridData(4, 4, true, true);
        leftGd.widthHint = 500;
        this.leftScroller.setLayoutData((Object)leftGd);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.leftScroller, (int)512, (int)20);
        this.leftScroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.leftScroller.setBackground(contentArea.getBackground());
        this.leftColumn = new Composite((Composite)this.leftScroller, 0);
        GridLayout leftLayout = new GridLayout();
        leftLayout.marginWidth = 0;
        leftLayout.marginHeight = 0;
        this.leftColumn.setLayout((Layout)leftLayout);
        this.leftScroller.setContent((Control)this.leftColumn);
        this.leftColumn.setBackground(contentArea.getBackground());
        this.rightColumn = new Composite(contentArea, 0);
        GridLayout rightLayout = new GridLayout();
        rightLayout.marginWidth = 0;
        rightLayout.marginHeight = 0;
        this.rightColumn.setLayout((Layout)rightLayout);
        GridData rightGd = new GridData(4, 128, false, false);
        rightGd.widthHint = 280;
        this.rightColumn.setLayoutData((Object)rightGd);
        this.rightColumn.setBackground(contentArea.getBackground());
        this.createCommentsSection(this.leftColumn);
        this.createAlarmsSection(this.leftColumn);
        this.createOverviewSection(this.rightColumn);
        this.createActionsSection(this.rightColumn);
    }

    private void createActions() {
        this.actionAskAi = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAssign = new /* Unavailable Anonymous Inner Class!! */;
        this.actionBlock = new /* Unavailable Anonymous Inner Class!! */;
        this.actionInProgress = new /* Unavailable Anonymous Inner Class!! */;
        this.actionResolve = new /* Unavailable Anonymous Inner Class!! */;
        this.actionReopen = new /* Unavailable Anonymous Inner Class!! */;
        this.actionClose = new /* Unavailable Anonymous Inner Class!! */;
        this.copyAlarmAction = new CopyTableRowsAction((ColumnViewer)this.alarmViewer, true);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAskAi);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAssign);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionInProgress);
        manager.add((IAction)this.actionBlock);
        manager.add((IAction)this.actionResolve);
        manager.add((IAction)this.actionReopen);
        manager.add((IAction)this.actionClose);
        super.fillLocalToolBar(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAskAi);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAssign);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionInProgress);
        manager.add((IAction)this.actionBlock);
        manager.add((IAction)this.actionResolve);
        manager.add((IAction)this.actionReopen);
        manager.add((IAction)this.actionClose);
        super.fillLocalMenu(manager);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillAlarmContextMenu(m));
        Menu menu = menuMgr.createContextMenu(this.alarmViewer.getControl());
        this.alarmViewer.getControl().setMenu(menu);
    }

    private void fillAlarmContextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyAlarmAction);
    }

    private void createOverviewSection(Composite parent) {
        Composite clientArea = new Composite(parent, 0);
        clientArea.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        clientArea.setLayout((Layout)layout);
        this.labelState = new CLabel(clientArea, 0);
        this.labelState.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelState.setFont(JFaceResources.getBannerFont());
        this.labelState.setBackground(clientArea.getBackground());
        new Label(clientArea, 0);
        Label label = new Label(clientArea, 0);
        label.setText(this.i18n.tr("Source"));
        label.setFont(this.boldFont);
        this.labelSource = new CLabel(clientArea, 0);
        this.labelSource.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelSource.setBackground(clientArea.getBackground());
        new Label(clientArea, 0);
        label = new Label(clientArea, 0);
        label.setText(this.i18n.tr("Assignee"));
        label.setFont(this.boldFont);
        this.labelAssigned = new CLabel(clientArea, 0);
        this.labelAssigned.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelAssigned.setBackground(clientArea.getBackground());
        this.labelAssigned.setForeground(WidgetHelper.getSystemColor((int)36));
        this.buttonAssign = new Button(clientArea, 8);
        this.buttonAssign.setText(this.i18n.tr("Assign..."));
        this.buttonAssign.setImage(SharedIcons.IMG_USER);
        this.buttonAssign.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonAssign.addListener(13, (Listener & Serializable)e -> this.assignIncident());
        new Label(clientArea, 0);
        label = new Label(clientArea, 0);
        label.setText(this.i18n.tr("Created"));
        label.setFont(this.boldFont);
        this.labelCreated = new CLabel(clientArea, 2);
        this.labelCreated.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelCreated.setBackground(clientArea.getBackground());
        new Label(clientArea, 0);
        label = new Label(clientArea, 0);
        label.setText(this.i18n.tr("Last change"));
        label.setFont(this.boldFont);
        this.labelLastChange = new CLabel(clientArea, 0);
        this.labelLastChange.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelLastChange.setBackground(clientArea.getBackground());
        new Label(clientArea, 0);
        label = new Label(clientArea, 0);
        label.setText(this.i18n.tr("Resolved"));
        label.setFont(this.boldFont);
        this.labelResolved = new CLabel(clientArea, 0);
        this.labelResolved.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelResolved.setBackground(clientArea.getBackground());
        new Label(clientArea, 0);
        label = new Label(clientArea, 0);
        label.setText(this.i18n.tr("Closed"));
        label.setFont(this.boldFont);
        this.labelClosed = new CLabel(clientArea, 0);
        this.labelClosed.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelClosed.setBackground(clientArea.getBackground());
    }

    private void createActionsSection(Composite parent) {
        new Label(parent, 0);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite clientArea = new Composite(parent, 0);
        clientArea.setBackground(parent.getBackground());
        clientArea.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(2, true);
        layout.marginTop = 10;
        layout.makeColumnsEqualWidth = true;
        clientArea.setLayout((Layout)layout);
        this.buttonInProgress = new Button(clientArea, 8);
        this.buttonInProgress.setText(this.i18n.tr("Start"));
        this.buttonInProgress.setImage(this.stateImages[IncidentState.IN_PROGRESS.getValue()]);
        this.buttonInProgress.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonInProgress.addListener(13, (Listener & Serializable)e -> this.changeIncidentState(IncidentState.IN_PROGRESS));
        this.buttonResolve = new Button(clientArea, 8);
        this.buttonResolve.setText(this.i18n.tr("Resolve"));
        this.buttonResolve.setImage(this.stateImages[IncidentState.RESOLVED.getValue()]);
        this.buttonResolve.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonResolve.addListener(13, (Listener & Serializable)e -> this.resolveIncident());
        this.buttonReopen = new Button(clientArea, 8);
        this.buttonReopen.setText(this.i18n.tr("Reopen"));
        this.buttonReopen.setImage(this.stateImages[IncidentState.OPEN.getValue()]);
        this.buttonReopen.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonReopen.addListener(13, (Listener & Serializable)e -> this.changeIncidentState(IncidentState.OPEN));
        this.buttonClose = new Button(clientArea, 8);
        this.buttonClose.setText(this.i18n.tr("Close"));
        this.buttonClose.setImage(this.stateImages[IncidentState.CLOSED.getValue()]);
        this.buttonClose.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonClose.addListener(13, (Listener & Serializable)e -> this.closeIncident());
        this.buttonBlock = new Button(clientArea, 8);
        this.buttonBlock.setText(this.i18n.tr("Mark as blocked..."));
        this.buttonBlock.setImage(this.stateImages[IncidentState.BLOCKED.getValue()]);
        this.buttonBlock.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.buttonBlock.addListener(13, (Listener & Serializable)e -> this.blockIncident());
    }

    private void createCommentsSection(Composite parent) {
        this.commentsArea = new Composite(parent, 0);
        this.commentsArea.setLayoutData((Object)new GridData(4, 128, true, false));
        this.commentsArea.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        this.commentsArea.setLayout((Layout)layout);
        this.buttonAddComment = new Button(this.commentsArea, 8);
        this.buttonAddComment.setText(this.i18n.tr("Add comment..."));
        this.buttonAddComment.setImage(this.imageCache.create(ResourceManager.getImageDescriptor((String)"icons/new_comment.png")));
        this.buttonAddComment.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.verticalIndent = 8;
        gd.widthHint = 180;
        this.buttonAddComment.setLayoutData((Object)gd);
    }

    private void createAlarmsSection(Composite parent) {
        new Label(parent, 0);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(parent, 0);
        Composite alarmsArea = new Composite(parent, 0);
        alarmsArea.setLayoutData((Object)new GridData(4, 128, true, false));
        alarmsArea.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        alarmsArea.setLayout((Layout)layout);
        Label label = new Label(alarmsArea, 0);
        label.setText(this.i18n.tr("Linked Alarms"));
        label.setFont(this.boldFont);
        String[] names = new String[]{this.i18n.tr("Severity"), this.i18n.tr("State"), this.i18n.tr("Source"), this.i18n.tr("Message"), this.i18n.tr("Created")};
        int[] widths = new int[]{90, 90, 150, 300, 150};
        this.alarmViewer = new SortableTableViewer(alarmsArea, names, widths, 4, 1024, 67584);
        this.alarmViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.alarmViewer.setLabelProvider((IBaseLabelProvider)new AlarmListLabelProvider(this));
        this.alarmViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, false));
        this.alarmViewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void updateOverview() {
        this.labelState.setImage(this.stateImages[this.incident.getState().getValue()]);
        this.labelState.setText(this.stateNames[this.incident.getState().getValue()]);
        AbstractObject object = this.session.findObjectById(this.incident.getSourceObjectId());
        if (object != null) {
            this.labelSource.setImage(this.objectLabelProvider.getImage((Object)object));
            this.labelSource.setText(object.getObjectName());
        } else {
            this.labelSource.setImage(SharedIcons.IMG_UNKNOWN_OBJECT);
            this.labelSource.setText("[" + this.incident.getSourceObjectId() + "]");
        }
        this.updateUserLabel(this.labelCreated, this.incident.getCreatedByUser(), this.incident.getCreationTime());
        this.updateUserLabel(this.labelAssigned, this.incident.getAssignedUserId(), null);
        this.labelLastChange.setText(DateFormatFactory.getDateTimeFormat().format(this.incident.getLastChangeTime()));
        if (this.incident.getResolveTime() != null) {
            this.updateUserLabel(this.labelResolved, this.incident.getResolvedByUser(), this.incident.getResolveTime());
        } else {
            this.labelResolved.setText("-");
        }
        if (this.incident.getCloseTime() != null) {
            this.updateUserLabel(this.labelClosed, this.incident.getClosedByUser(), this.incident.getCloseTime());
        } else {
            this.labelClosed.setText("-");
        }
    }

    private void updateUserLabel(CLabel label, int userId, Date timestamp) {
        Object text;
        if (userId == 0) {
            label.setText(timestamp != null ? DateFormatFactory.getDateTimeFormat().format(timestamp) : this.i18n.tr("(unassigned)"));
            label.setImage(SharedIcons.IMG_DISABLE);
            return;
        }
        AbstractUserObject user = this.session.findUserDBObjectById(userId, () -> label.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */));
        Object object = text = user != null ? user.getName() : "[" + userId + "]";
        if (timestamp != null) {
            text = DateFormatFactory.getDateTimeFormat().format(timestamp) + "\nby " + (String)text;
        } else {
            label.setImage(SharedIcons.IMG_USER);
        }
        label.setText((String)text);
    }

    private void updateDetails() {
        this.textTitle.setText(this.incident.getTitle() != null ? this.incident.getTitle() : "");
        this.textTitle.setEditable(false);
        this.setDetailsModified(false);
        boolean canEdit = !this.incident.isClosed();
        this.buttonEdit.setVisible(canEdit);
        this.buttonSave.setVisible(false);
        ((GridData)this.buttonSave.getLayoutData()).exclude = true;
        this.buttonCancel.setVisible(false);
        ((GridData)this.buttonCancel.getLayoutData()).exclude = true;
        this.buttonArea.setVisible(canEdit);
        this.buttonArea.layout(true, true);
    }

    private void updateComments(List<IncidentComment> comments) {
        for (IncidentCommentsEditor editor : this.commentEditors.values()) {
            editor.dispose();
        }
        this.commentEditors.clear();
        for (IncidentComment comment : comments) {
            IncidentCommentsEditor editor = new IncidentCommentsEditor(this.commentsArea, comment);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            editor.setLayoutData((Object)gd);
            editor.moveAbove((Control)this.buttonAddComment);
            this.commentEditors.put(comment.getId(), editor);
        }
        this.buttonAddComment.setEnabled(!this.incident.isClosed());
    }

    private void updateAlarms(Alarm[] alarms) {
        ArrayList<Alarm> validAlarms = new ArrayList<Alarm>();
        for (Alarm alarm : alarms) {
            if (alarm == null) continue;
            validAlarms.add(alarm);
        }
        this.alarmViewer.setInput((Object)validAlarms.toArray());
    }

    private void updateActionStates() {
        boolean canModify = this.incident != null && !this.incident.isClosed();
        IncidentState state = this.incident != null ? this.incident.getState() : null;
        boolean canBlock = canModify && state != IncidentState.BLOCKED && state != IncidentState.RESOLVED;
        boolean canSetInProgress = canModify && (state == IncidentState.OPEN || state == IncidentState.BLOCKED);
        boolean canResolve = canModify && !this.incident.isResolved();
        boolean canReopen = this.incident != null && state == IncidentState.RESOLVED;
        boolean canClose = this.incident != null && !this.incident.isClosed();
        this.actionAssign.setEnabled(canModify);
        this.actionBlock.setEnabled(canBlock);
        this.actionInProgress.setEnabled(canSetInProgress);
        this.actionResolve.setEnabled(canResolve);
        this.actionReopen.setEnabled(canReopen);
        this.actionClose.setEnabled(canClose);
        this.buttonAssign.setEnabled(canModify);
        this.buttonBlock.setEnabled(canBlock);
        this.buttonInProgress.setEnabled(canSetInProgress);
        this.buttonResolve.setEnabled(canResolve);
        this.buttonReopen.setEnabled(canReopen);
        this.buttonClose.setEnabled(canClose);
    }

    private void updateLayout() {
        this.content.layout(true, true);
        this.leftColumn.layout(true, true);
        this.leftScroller.setMinSize(this.leftColumn.computeSize(this.leftScroller.getClientArea().width, -1));
    }

    private void setDetailsModified(boolean modified) {
        this.buttonSave.setEnabled(modified && this.incident != null && !this.incident.isClosed());
    }

    private void enterEditMode() {
        this.textTitle.setEditable(true);
        this.buttonEdit.setVisible(false);
        ((GridData)this.buttonEdit.getLayoutData()).exclude = true;
        this.buttonSave.setVisible(true);
        ((GridData)this.buttonSave.getLayoutData()).exclude = false;
        this.buttonSave.setEnabled(false);
        this.buttonCancel.setVisible(true);
        ((GridData)this.buttonCancel.getLayoutData()).exclude = false;
        this.buttonArea.layout(true, true);
        this.textTitle.setFocus();
    }

    private void cancelEditMode() {
        this.textTitle.setText(this.incident.getTitle() != null ? this.incident.getTitle() : "");
        this.textTitle.setEditable(false);
        this.buttonEdit.setVisible(true);
        ((GridData)this.buttonEdit.getLayoutData()).exclude = false;
        this.buttonSave.setVisible(false);
        ((GridData)this.buttonSave.getLayoutData()).exclude = true;
        this.buttonCancel.setVisible(false);
        ((GridData)this.buttonCancel.getLayoutData()).exclude = true;
        this.buttonArea.layout(true, true);
        this.setDetailsModified(false);
    }

    private void exitEditMode() {
        this.textTitle.setEditable(false);
        this.buttonEdit.setVisible(true);
        ((GridData)this.buttonEdit.getLayoutData()).exclude = false;
        this.buttonSave.setVisible(false);
        ((GridData)this.buttonSave.getLayoutData()).exclude = true;
        this.buttonCancel.setVisible(false);
        ((GridData)this.buttonCancel.getLayoutData()).exclude = true;
        this.buttonArea.layout(true, true);
    }

    private void saveDetails() {
        String title = this.textTitle.getText().trim();
        if (title.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Title cannot be empty"));
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void assignIncident() {
        UserSelectionDialog dialog = new UserSelectionDialog(this.getWindow().getShell(), User.class);
        dialog.enableMultiSelection(false);
        if (dialog.open() != 0) {
            return;
        }
        int userId = dialog.getSelection()[0].getId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void blockIncident() {
        EditIncidentCommentDialog dialog = new EditIncidentCommentDialog(this.getWindow().getShell(), null, this.i18n.tr("Block Incident"), this.i18n.tr("Reason for blocking"));
        if (dialog.open() != 0) {
            return;
        }
        String comment = dialog.getText();
        if (comment.trim().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Comment is required when blocking an incident"));
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void changeIncidentState(IncidentState newState) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void resolveIncident() {
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Resolve Incident"), (String)this.i18n.tr("Are you sure you want to resolve this incident? All linked alarms will also be resolved."))) {
            return;
        }
        this.changeIncidentState(IncidentState.RESOLVED);
    }

    private void closeIncident() {
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Close Incident"), (String)this.i18n.tr("Are you sure you want to close this incident? All linked alarms will be terminated."))) {
            return;
        }
        this.changeIncidentState(IncidentState.CLOSED);
    }

    private void addComment() {
        EditIncidentCommentDialog dialog = new EditIncidentCommentDialog(this.getWindow().getShell(), null);
        if (dialog.open() == 0) {
            String comment = dialog.getText();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    public void dispose() {
        this.imageCache.dispose();
        this.objectLabelProvider.dispose();
        super.dispose();
    }

    public String getFullName() {
        return this.getName();
    }

    public boolean isValidForContext(Object context) {
        if (this.getObjectId() == 0L && this.getContextId() == 0L) {
            return true;
        }
        return context != null && context instanceof AbstractObject && (((AbstractObject)context).getObjectId() == this.getObjectId() || ((AbstractObject)context).getObjectId() == this.getContextId());
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("incidentId", this.incidentId);
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.incidentId = memento.getAsLong("incidentId", 0L);
        this.setName(String.format(LocalizationHelper.getI18n(IncidentDetails.class).tr("Incident [%d]"), this.incidentId));
        if (this.incidentId == 0L) {
            throw new ViewNotRestoredException(this.i18n.tr("Invalid incident id"));
        }
    }
}

