/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.imagelibrary.widgets;

import java.util.UUID;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.NXCommon;
import org.netxms.client.LibraryImage;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.modules.imagelibrary.ImageUpdateListener;
import org.netxms.nxmc.modules.imagelibrary.dialogs.ImageSelectionDialog;
import org.xnap.commons.i18n.I18n;

public class ImageSelector
extends AbstractSelector
implements ImageUpdateListener {
    private I18n i18n = LocalizationHelper.getI18n(ImageSelector.class);
    private UUID imageGuid = null;
    private Shell parentShell = null;

    public ImageSelector(Composite parent, int style) {
        super(parent, style, new SelectorConfigurator().setShowClearButton(true).setSelectionButtonToolTip(LocalizationHelper.getI18n(ImageSelector.class).tr("Select image from image library")));
        ImageProvider.getInstance().addUpdateListener((ImageUpdateListener)this);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void selectionButtonHandler() {
        ImageSelectionDialog dlg = new ImageSelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            LibraryImage image = dlg.getImage();
            if (image != null) {
                this.setText(image.getName());
                this.setImage(ImageProvider.getInstance().getImage(image.getGuid()));
                this.imageGuid = dlg.getImageGuid();
            } else {
                this.setText(this.i18n.tr("<default>"));
                this.setImage(null);
                this.imageGuid = null;
            }
            this.getParent().layout();
            if (this.parentShell != null) {
                this.parentShell.pack(true);
            }
        }
    }

    protected void clearButtonHandler() {
        this.setText(this.i18n.tr("<default>"));
        this.setImage(null);
        this.imageGuid = null;
        this.getParent().layout();
        if (this.parentShell != null) {
            this.parentShell.pack(true);
        }
    }

    public UUID getImageGuid() {
        return this.imageGuid;
    }

    public void setImageGuid(UUID imageGuid, boolean redoLayout) {
        this.imageGuid = imageGuid;
        if (imageGuid == null || imageGuid.equals(NXCommon.EMPTY_GUID)) {
            this.setText(this.i18n.tr("<default>"));
            this.setImage(null);
        } else {
            LibraryImage image = ImageProvider.getInstance().getLibraryImageObject(imageGuid);
            if (image != null) {
                this.setText(image.getName());
                this.setImage(ImageProvider.getInstance().getImage(imageGuid));
            } else {
                this.setText("<?>" + imageGuid.toString());
                this.setImage(null);
            }
        }
        if (redoLayout) {
            this.getParent().layout();
            if (this.parentShell != null) {
                this.parentShell.pack(true);
            }
        }
    }

    public void imageUpdated(UUID guid) {
        if (guid.equals(this.imageGuid)) {
            this.setImage(ImageProvider.getInstance().getImage(this.imageGuid));
            this.getParent().layout();
            if (this.parentShell != null) {
                this.parentShell.pack(true);
            }
        }
    }

    public Shell getParentShell() {
        return this.parentShell;
    }

    public void setParentShell(Shell parentShell) {
        this.parentShell = parentShell;
    }
}

