/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.dialogs;

import java.util.List;
import java.util.UUID;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.netxms.client.events.EPPConflict;
import org.netxms.client.events.EventProcessingPolicy;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class EPPConflictDialog
extends Dialog {
    public static final int RELOAD = 0;
    public static final int CANCEL = 1;
    private final I18n i18n = LocalizationHelper.getI18n(EPPConflictDialog.class);
    private List<EPPConflict> conflicts;
    private EventProcessingPolicy policy;
    private TableViewer viewer;

    public EPPConflictDialog(Shell parentShell, List<EPPConflict> conflicts, EventProcessingPolicy policy) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.conflicts = conflicts;
        this.policy = policy;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Save Conflicts Detected"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        Label message = new Label(container, 64);
        message.setText(this.i18n.tr("Some rules have been modified by other users while you were editing. Your changes cannot be saved until you reload the policy from the server. Your local changes will be lost."));
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 500;
        message.setLayoutData((Object)gd);
        this.viewer = new TableViewer(container, 68096);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        table.setLayoutData((Object)gd);
        TableViewerColumn colRuleNum = new TableViewerColumn(this.viewer, 0);
        colRuleNum.getColumn().setText(this.i18n.tr("Rule #"));
        colRuleNum.getColumn().setWidth(60);
        colRuleNum.setLabelProvider((CellLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        TableViewerColumn colDesc = new TableViewerColumn(this.viewer, 0);
        colDesc.getColumn().setText(this.i18n.tr("Description"));
        colDesc.getColumn().setWidth(200);
        colDesc.setLabelProvider((CellLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        TableViewerColumn colType = new TableViewerColumn(this.viewer, 0);
        colType.getColumn().setText(this.i18n.tr("Conflict"));
        colType.getColumn().setWidth(120);
        colType.setLabelProvider((CellLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        TableViewerColumn colModifiedBy = new TableViewerColumn(this.viewer, 0);
        colModifiedBy.getColumn().setText(this.i18n.tr("Modified By"));
        colModifiedBy.getColumn().setWidth(180);
        colModifiedBy.setLabelProvider((CellLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)this.conflicts);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.i18n.tr("Reload from Server"), true);
        this.createButton(parent, 1, this.i18n.tr("Cancel"), false);
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    private EventProcessingPolicyRule findRule(UUID guid) {
        for (EventProcessingPolicyRule rule : this.policy.getRules()) {
            if (!rule.getGuid().equals(guid)) continue;
            return rule;
        }
        return null;
    }

    private int findRuleNumber(UUID guid) {
        int num = 1;
        for (EventProcessingPolicyRule rule : this.policy.getRules()) {
            if (rule.getGuid().equals(guid)) {
                return num;
            }
            ++num;
        }
        return -1;
    }
}

