/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.datacollection.DciTemplateConfig;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.TemplateDciSelector;
import org.xnap.commons.i18n.I18n;

public class DciTemplateSelectionWidget
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(DciTemplateSelectionWidget.class);
    private TemplateDciSelector dciNameSelector;
    private TemplateDciSelector dciDescriptionSelector;
    private TemplateDciSelector dciTagSelector;
    private Button checkRegexMatch;
    private Button checkMultiMatch;
    private List<ModifyListener> modifyListeners = new ArrayList();

    public DciTemplateSelectionWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group optionsGroup = new Group((Composite)this, 0);
        optionsGroup.setText(this.i18n.tr("Matching options"));
        optionsGroup.setLayout((Layout)new GridLayout());
        optionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dciNameSelector = new TemplateDciSelector((Composite)optionsGroup, 0);
        this.dciNameSelector.setLabel(this.i18n.tr("Metric"));
        this.dciNameSelector.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dciNameSelector.addModifyListener(arg_0 -> this.fireModifyListeners(arg_0));
        this.dciDescriptionSelector = new TemplateDciSelector((Composite)optionsGroup, 0);
        this.dciDescriptionSelector.setLabel(this.i18n.tr("DCI display name"));
        this.dciDescriptionSelector.setField(TemplateDciSelector.Field.DESCRIPTION);
        this.dciDescriptionSelector.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dciDescriptionSelector.addModifyListener(arg_0 -> this.fireModifyListeners(arg_0));
        this.dciTagSelector = new TemplateDciSelector((Composite)optionsGroup, 0);
        this.dciTagSelector.setLabel(this.i18n.tr("DCI tag"));
        this.dciTagSelector.setField(TemplateDciSelector.Field.TAG);
        this.dciTagSelector.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dciTagSelector.addModifyListener(arg_0 -> this.fireModifyListeners(arg_0));
        this.checkRegexMatch = new Button((Composite)optionsGroup, 32);
        this.checkRegexMatch.setText(this.i18n.tr("Use regular expressions for DCI matching"));
        this.checkMultiMatch = new Button((Composite)optionsGroup, 32);
        this.checkMultiMatch.setText(this.i18n.tr("Multiple match"));
        this.checkMultiMatch.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public void setConfig(DciTemplateConfig config) {
        this.dciNameSelector.setText(config.getDciName());
        this.dciDescriptionSelector.setText(config.getDciDescription());
        this.dciTagSelector.setText(config.getDciTag());
        this.checkRegexMatch.setSelection(config.isRegexMatch());
        this.checkMultiMatch.setSelection(config.isMultiMatch());
    }

    public DciTemplateConfig getConfig() {
        DciTemplateConfig config = new DciTemplateConfig();
        config.setDciName(this.dciNameSelector.getText());
        config.setDciDescription(this.dciDescriptionSelector.getText());
        config.setDciTag(this.dciTagSelector.getText());
        config.setRegexMatch(this.checkRegexMatch.getSelection());
        config.setMultiMatch(this.checkMultiMatch.getSelection());
        return config;
    }

    public void setMultiMatchVisible(boolean visible) {
        this.checkMultiMatch.setVisible(visible);
        ((GridData)this.checkMultiMatch.getLayoutData()).exclude = !visible;
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove(listener);
    }

    private void fireModifyListeners(ModifyEvent e) {
        Event event = new Event();
        event.widget = this;
        ModifyEvent me = new ModifyEvent(event);
        for (ModifyListener listener : this.modifyListeners) {
            listener.modifyText(me);
        }
    }
}

