/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.datacollection.WebServiceDefinition;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.HeaderEditDialog;
import org.netxms.nxmc.modules.datacollection.propertypages.WebServiceHeaders;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class WebServiceHeaders
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(WebServiceHeaders.class);
    private WebServiceDefinition definition;
    private Map<String, String> headers;
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonDelete;

    public WebServiceHeaders(WebServiceDefinition definition) {
        super(LocalizationHelper.getI18n(WebServiceHeaders.class).tr("Headers"));
        this.noDefaultAndApplyButton();
        this.definition = definition;
        this.headers = new HashMap(definition.getHeaders());
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67584);
        this.setupViewer();
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 450;
        this.viewer.getTable().setLayoutData((Object)gd);
        Composite buttonArea = new Composite(dialogArea, 0);
        RowLayout btnLayout = new RowLayout();
        btnLayout.type = 512;
        btnLayout.marginBottom = 0;
        btnLayout.marginLeft = 0;
        btnLayout.marginRight = 0;
        btnLayout.marginTop = 0;
        btnLayout.fill = true;
        btnLayout.spacing = 4;
        buttonArea.setLayout((Layout)btnLayout);
        gd = new GridData();
        gd.verticalAlignment = 128;
        buttonArea.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttonArea, 8);
        this.buttonAdd.setText(this.i18n.tr("&Add..."));
        this.buttonAdd.setLayoutData((Object)new RowData(90, -1));
        this.buttonAdd.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonEdit = new Button(buttonArea, 8);
        this.buttonEdit.setText(this.i18n.tr("&Edit..."));
        this.buttonEdit.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonEdit.setEnabled(false);
        this.buttonDelete = new Button(buttonArea, 8);
        this.buttonDelete.setText(this.i18n.tr("&Delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonDelete.setEnabled(false);
        return dialogArea;
    }

    private void addHeader() {
        HeaderEditDialog dlg = new HeaderEditDialog(this.getShell(), null, null);
        if (dlg.open() == 0) {
            this.headers.put(dlg.getName(), dlg.getValue());
            this.viewer.refresh();
        }
    }

    private void editHeader() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry e = (Map.Entry)selection.getFirstElement();
        HeaderEditDialog dlg = new HeaderEditDialog(this.getShell(), (String)e.getKey(), (String)e.getValue());
        if (dlg.open() == 0) {
            this.headers.put(dlg.getName(), dlg.getValue());
            this.viewer.refresh();
        }
    }

    private void deleteHeaders() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            this.headers.remove(((Map.Entry)o).getKey());
        }
        this.viewer.refresh();
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (String)"WebServiceHeaders");
    }

    public boolean performCancel() {
        if (this.isControlCreated()) {
            this.saveSettings();
        }
        return super.performCancel();
    }

    protected boolean applyChanges(boolean isApply) {
        this.definition.getHeaders().clear();
        for (Map.Entry e : this.headers.entrySet()) {
            this.definition.setHeader((String)e.getKey(), (String)e.getValue());
        }
        this.saveSettings();
        return true;
    }

    private void setupViewer() {
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        TableColumn tc = new TableColumn(table, 16384);
        tc.setText(this.i18n.tr("Name"));
        tc.setWidth(200);
        tc = new TableColumn(table, 16384);
        tc.setText(this.i18n.tr("Value"));
        tc.setWidth(200);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new HeaderLabelProvider(this));
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setInput(this.headers.entrySet());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        WidgetHelper.restoreColumnSettings((Table)table, (String)"WebServiceHeaders");
    }
}

