/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import com.google.gson.Gson;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.TableComparisonChartConfig;
import org.netxms.nxmc.modules.dashboards.config.TablePieChartConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.TableComparisonChartElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablePieChartElement
extends TableComparisonChartElement {
    private static final Logger logger = LoggerFactory.getLogger(TablePieChartElement.class);

    public TablePieChartElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = (TableComparisonChartConfig)new Gson().fromJson(element.getData(), TablePieChartConfig.class);
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new TablePieChartConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendPosition(this.config.getLegendPosition());
        chartConfig.setLegendVisible(this.config.isShowLegend());
        chartConfig.setExtendedLegend(this.config.isExtendedLegend());
        chartConfig.setTranslucent(this.config.isTranslucent());
        this.chart = new Chart(this.getContentArea(), 0, ChartType.PIE, chartConfig, (View)view);
        this.startRefreshTimer();
    }
}

