/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.actions.views;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerAction;
import org.netxms.client.SessionListener;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.actions.dialogs.EditActionDlg;
import org.netxms.nxmc.modules.actions.views.helpers.ActionComparator;
import org.netxms.nxmc.modules.actions.views.helpers.ActionLabelProvider;
import org.netxms.nxmc.modules.actions.views.helpers.ActionManagerFilter;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ActionManager
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(ActionManager.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_RCPT = 2;
    public static final int COLUMN_SUBJ = 3;
    public static final int COLUMN_DATA = 4;
    public static final int COLUMN_CHANNEL = 5;
    private SortableTableViewer viewer;
    private NXCSession session;
    private SessionListener sessionListener;
    private Map<Long, ServerAction> actions = new HashMap();
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionClone;
    private Action actionEnable;
    private Action actionDisable;

    public ActionManager() {
        super(LocalizationHelper.getI18n(ActionManager.class).tr("Actions"), ResourceManager.getImageDescriptor((String)"icons/config-views/actions.png"), "configuration.actions", true);
        this.session = Registry.getSession();
    }

    protected void createContent(Composite parent) {
        String[] columnNames = new String[]{this.i18n.tr("Name"), this.i18n.tr("Type"), this.i18n.tr("Recipient"), this.i18n.tr("Subject"), this.i18n.tr("Data"), this.i18n.tr("Channel")};
        int[] columnWidths = new int[]{150, 90, 100, 120, 200, 100};
        this.viewer = new SortableTableViewer(parent, columnNames, columnWidths, 0, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"ActionManager");
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ActionLabelProvider labelProvider = new ActionLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new ActionComparator());
        ActionManagerFilter filter = new ActionManagerFilter(labelProvider);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.viewer.addFilter((ViewerFilter)filter);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createActions() {
        this.actionNew = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionNew);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M3+ENTER", (IAction)this.actionEdit);
        this.actionClone = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M3+C", (IAction)this.actionClone);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
        this.actionEnable = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+E", (IAction)this.actionEnable);
        this.actionDisable = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+I", (IAction)this.actionDisable);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillContextMenu(m));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionClone);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionEnable);
        manager.add((IAction)this.actionDisable);
        manager.add((IAction)this.actionDelete);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
    }

    private void createAction() {
        ServerAction action = new ServerAction(0L);
        EditActionDlg dlg = new EditActionDlg(this.getWindow().getShell(), action, true);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void cloneAction() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ServerAction action = new ServerAction(0L, (ServerAction)selection.getFirstElement());
        action.setName("Copy of " + action.getName());
        EditActionDlg dlg = new EditActionDlg(this.getWindow().getShell(), action, true);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editAction() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ServerAction action = (ServerAction)selection.getFirstElement();
        EditActionDlg dlg = new EditActionDlg(this.getWindow().getShell(), action, false);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteActions() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Confirm Delete"), (String)this.i18n.tr("Do you really want to delete selected actions?"))) {
            return;
        }
        Object[] objects = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void enableActions(boolean enable) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void updateActionsList() {
        this.viewer.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }
}

